/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.data.pipeline.core.metadata.model;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import lombok.Generated;
import lombok.NonNull;
import org.apache.shardingsphere.data.pipeline.core.metadata.model.PipelineColumnMetaData;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class PipelineTableMetaData {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(PipelineTableMetaData.class);
    @NonNull
    private final String name;
    private final Map<String, PipelineColumnMetaData> columnMetaDataMap;
    private final List<String> columnNames;
    private final List<String> primaryKeyColumns;

    public PipelineTableMetaData(String name, Map<String, PipelineColumnMetaData> columnMetaDataMap) {
        this.name = name;
        this.columnMetaDataMap = columnMetaDataMap;
        ArrayList<PipelineColumnMetaData> columnMetaDataList = new ArrayList<PipelineColumnMetaData>(columnMetaDataMap.values());
        Collections.sort(columnMetaDataList);
        this.columnNames = Collections.unmodifiableList(columnMetaDataList.stream().map(PipelineColumnMetaData::getName).collect(Collectors.toList()));
        this.primaryKeyColumns = Collections.unmodifiableList(columnMetaDataList.stream().filter(PipelineColumnMetaData::isPrimaryKey).map(PipelineColumnMetaData::getName).collect(Collectors.toList()));
    }

    public PipelineColumnMetaData getColumnMetaData(int columnIndex) {
        return this.getColumnMetaData(this.columnNames.get(columnIndex));
    }

    public PipelineColumnMetaData getColumnMetaData(String columnName) {
        PipelineColumnMetaData result = this.columnMetaDataMap.get(columnName);
        if (null == result) {
            log.warn("getColumnMetaData, can not get column metadata for column name '{}', columnNames={}", (Object)columnName, this.columnNames);
        }
        return result;
    }

    public boolean isPrimaryKey(int columnIndex) {
        return columnIndex < this.columnNames.size() && this.columnMetaDataMap.get(this.columnNames.get(columnIndex)).isPrimaryKey();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PipelineTableMetaData that = (PipelineTableMetaData)o;
        return this.name.equals(that.name);
    }

    public int hashCode() {
        return Objects.hash(this.name);
    }

    @Generated
    public String toString() {
        return "PipelineTableMetaData(name=" + this.name + ", columnMetaDataMap=" + this.columnMetaDataMap + ", columnNames=" + this.getColumnNames() + ", primaryKeyColumns=" + this.getPrimaryKeyColumns() + ")";
    }

    @Generated
    public List<String> getColumnNames() {
        return this.columnNames;
    }

    @Generated
    public List<String> getPrimaryKeyColumns() {
        return this.primaryKeyColumns;
    }
}

