/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.data.pipeline.core.spi.check.consistency;

import java.util.Iterator;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import lombok.Generated;
import org.apache.shardingsphere.data.pipeline.api.check.consistency.DataCalculateParameter;
import org.apache.shardingsphere.data.pipeline.core.spi.check.consistency.AbstractSingleTableDataCalculator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractStreamingSingleTableDataCalculator
extends AbstractSingleTableDataCalculator {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AbstractStreamingSingleTableDataCalculator.class);

    public final Iterable<Object> calculate(DataCalculateParameter dataCalculateParameter) {
        return new ResultIterable(dataCalculateParameter);
    }

    protected abstract Optional<Object> calculateChunk(DataCalculateParameter var1);

    @Generated
    public AbstractStreamingSingleTableDataCalculator() {
    }

    final class ResultIterator
    implements Iterator<Object> {
        private final DataCalculateParameter dataCalculateParameter;
        private final AtomicInteger calculationCount = new AtomicInteger(0);
        private volatile Optional<Object> nextResult;

        @Override
        public boolean hasNext() {
            this.calculateIfNecessary();
            return this.nextResult.isPresent();
        }

        @Override
        public Object next() {
            this.calculateIfNecessary();
            Optional<Object> nextResult = this.nextResult;
            this.dataCalculateParameter.setPreviousCalculatedResult(nextResult.orElse(null));
            this.nextResult = null;
            return nextResult.orElse(null);
        }

        private void calculateIfNecessary() {
            if (null != this.nextResult) {
                return;
            }
            this.nextResult = AbstractStreamingSingleTableDataCalculator.this.calculateChunk(this.dataCalculateParameter);
            if (!this.nextResult.isPresent()) {
                log.info("nextResult not present, calculation done. calculationCount={}", (Object)this.calculationCount);
            }
            if (this.calculationCount.incrementAndGet() % 1000000 == 0) {
                log.warn("possible infinite loop, calculationCount={}", (Object)this.calculationCount);
            }
        }

        @Generated
        public ResultIterator(DataCalculateParameter dataCalculateParameter) {
            this.dataCalculateParameter = dataCalculateParameter;
        }
    }

    final class ResultIterable
    implements Iterable<Object> {
        private final DataCalculateParameter dataCalculateParameter;

        @Override
        public Iterator<Object> iterator() {
            return new ResultIterator(this.dataCalculateParameter);
        }

        @Generated
        public ResultIterable(DataCalculateParameter dataCalculateParameter) {
            this.dataCalculateParameter = dataCalculateParameter;
        }
    }
}

