/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.data.pipeline.core.spi.ingest.channel;

import com.google.common.base.Strings;
import java.util.Properties;
import org.apache.shardingsphere.data.pipeline.api.ingest.channel.AckCallback;
import org.apache.shardingsphere.data.pipeline.api.ingest.channel.PipelineChannel;
import org.apache.shardingsphere.data.pipeline.core.ingest.channel.memory.MultiplexMemoryPipelineChannel;
import org.apache.shardingsphere.data.pipeline.core.ingest.channel.memory.SimpleMemoryPipelineChannel;
import org.apache.shardingsphere.data.pipeline.spi.ingest.channel.PipelineChannelFactory;

public final class MemoryPipelineChannelFactory
implements PipelineChannelFactory {
    public static final String TYPE = "MEMORY";
    private static final String BLOCK_QUEUE_SIZE_KEY = "block-queue-size";
    private int blockQueueSize = 10000;
    private Properties props = new Properties();

    public Properties getProps() {
        return this.props;
    }

    public void setProps(Properties props) {
        this.props = props;
    }

    public void init() {
        String blockQueueSizeValue = this.props.getProperty(BLOCK_QUEUE_SIZE_KEY);
        if (!Strings.isNullOrEmpty((String)blockQueueSizeValue)) {
            this.blockQueueSize = Integer.parseInt(blockQueueSizeValue);
        }
    }

    public PipelineChannel createPipelineChannel(int outputConcurrency, AckCallback ackCallback) {
        if (1 == outputConcurrency) {
            return new SimpleMemoryPipelineChannel(this.blockQueueSize, ackCallback);
        }
        return new MultiplexMemoryPipelineChannel(outputConcurrency, this.blockQueueSize, ackCallback);
    }

    public String getType() {
        return TYPE;
    }
}

