/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.data.pipeline.core.spi.ratelimit;

import com.google.common.base.Strings;
import com.google.common.util.concurrent.RateLimiter;
import java.util.Properties;
import lombok.Generated;
import org.apache.shardingsphere.data.pipeline.api.job.JobOperationType;
import org.apache.shardingsphere.data.pipeline.spi.ratelimit.JobRateLimitAlgorithm;

public final class QPSJobRateLimitAlgorithm
implements JobRateLimitAlgorithm {
    private static final String QPS_KEY = "qps";
    private int qps = 50;
    private RateLimiter rateLimiter;
    private Properties props = new Properties();

    public void init() {
        String qpsValue = this.props.getProperty(QPS_KEY);
        if (!Strings.isNullOrEmpty((String)qpsValue)) {
            this.qps = Integer.parseInt(qpsValue);
        }
        this.rateLimiter = RateLimiter.create((double)this.qps);
    }

    public String getType() {
        return "QPS";
    }

    public void intercept(JobOperationType type, Number data) {
        if (type != JobOperationType.SELECT) {
            return;
        }
        this.rateLimiter.acquire();
    }

    public String toString() {
        return "QPSJobRateLimitAlgorithm{props=" + this.props + '}';
    }

    @Generated
    public Properties getProps() {
        return this.props;
    }

    @Generated
    public void setProps(Properties props) {
        this.props = props;
    }
}

