/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.data.pipeline.core.sqlbuilder;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import lombok.Generated;
import org.apache.shardingsphere.data.pipeline.api.ingest.record.Column;
import org.apache.shardingsphere.data.pipeline.api.ingest.record.DataRecord;
import org.apache.shardingsphere.data.pipeline.core.record.RecordUtil;
import org.apache.shardingsphere.data.pipeline.spi.sqlbuilder.PipelineSQLBuilder;

public abstract class AbstractPipelineSQLBuilder
implements PipelineSQLBuilder {
    private static final String INSERT_SQL_CACHE_KEY_PREFIX = "INSERT_";
    private static final String UPDATE_SQL_CACHE_KEY_PREFIX = "UPDATE_";
    private static final String DELETE_SQL_CACHE_KEY_PREFIX = "DELETE_";
    private final ConcurrentMap<String, String> sqlCacheMap = new ConcurrentHashMap<String, String>();
    private final Map<String, Set<String>> shardingColumnsMap;

    public AbstractPipelineSQLBuilder() {
        this.shardingColumnsMap = Collections.emptyMap();
    }

    public AbstractPipelineSQLBuilder(Map<String, Set<String>> shardingColumnsMap) {
        this.shardingColumnsMap = shardingColumnsMap;
    }

    protected abstract String getLeftIdentifierQuoteString();

    protected abstract String getRightIdentifierQuoteString();

    public StringBuilder quote(String item) {
        return new StringBuilder().append(this.getLeftIdentifierQuoteString()).append(item).append(this.getRightIdentifierQuoteString());
    }

    public String buildInsertSQL(DataRecord dataRecord) {
        String sqlCacheKey = INSERT_SQL_CACHE_KEY_PREFIX + dataRecord.getTableName();
        if (!this.sqlCacheMap.containsKey(sqlCacheKey)) {
            this.sqlCacheMap.put(sqlCacheKey, this.buildInsertSQLInternal(dataRecord.getTableName(), dataRecord.getColumns()));
        }
        return (String)this.sqlCacheMap.get(sqlCacheKey);
    }

    private String buildInsertSQLInternal(String tableName, List<Column> columns) {
        StringBuilder columnsLiteral = new StringBuilder();
        StringBuilder holder = new StringBuilder();
        for (Column each : columns) {
            columnsLiteral.append(String.format("%s,", this.quote(each.getName())));
            holder.append("?,");
        }
        columnsLiteral.setLength(columnsLiteral.length() - 1);
        holder.setLength(holder.length() - 1);
        return String.format("INSERT INTO %s(%s) VALUES(%s)", this.quote(tableName), columnsLiteral, holder);
    }

    public String buildUpdateSQL(DataRecord dataRecord, Collection<Column> conditionColumns) {
        String sqlCacheKey = UPDATE_SQL_CACHE_KEY_PREFIX + dataRecord.getTableName();
        if (!this.sqlCacheMap.containsKey(sqlCacheKey)) {
            this.sqlCacheMap.put(sqlCacheKey, this.buildUpdateSQLInternal(dataRecord.getTableName(), conditionColumns));
        }
        StringBuilder updatedColumnString = new StringBuilder();
        for (Column each : this.extractUpdatedColumns(dataRecord.getColumns(), dataRecord)) {
            updatedColumnString.append(String.format("%s = ?,", this.quote(each.getName())));
        }
        updatedColumnString.setLength(updatedColumnString.length() - 1);
        return String.format((String)this.sqlCacheMap.get(sqlCacheKey), updatedColumnString);
    }

    private String buildUpdateSQLInternal(String tableName, Collection<Column> conditionColumns) {
        return String.format("UPDATE %s SET %%s WHERE %s", this.quote(tableName), this.buildWhereSQL(conditionColumns));
    }

    public List<Column> extractUpdatedColumns(Collection<Column> columns, DataRecord record) {
        return new ArrayList<Column>(RecordUtil.extractUpdatedColumns(record));
    }

    public String buildDeleteSQL(DataRecord dataRecord, Collection<Column> conditionColumns) {
        String sqlCacheKey = DELETE_SQL_CACHE_KEY_PREFIX + dataRecord.getTableName();
        if (!this.sqlCacheMap.containsKey(sqlCacheKey)) {
            this.sqlCacheMap.put(sqlCacheKey, this.buildDeleteSQLInternal(dataRecord.getTableName(), conditionColumns));
        }
        return (String)this.sqlCacheMap.get(sqlCacheKey);
    }

    public String buildTruncateSQL(String tableName) {
        return String.format("TRUNCATE TABLE %s", this.quote(tableName));
    }

    private String buildDeleteSQLInternal(String tableName, Collection<Column> conditionColumns) {
        return String.format("DELETE FROM %s WHERE %s", this.quote(tableName), this.buildWhereSQL(conditionColumns));
    }

    private String buildWhereSQL(Collection<Column> conditionColumns) {
        StringBuilder where = new StringBuilder();
        for (Column each : conditionColumns) {
            where.append(String.format("%s = ? and ", this.quote(each.getName())));
        }
        where.setLength(where.length() - 5);
        return where.toString();
    }

    public String buildCountSQL(String tableName) {
        return String.format("SELECT COUNT(*) FROM %s", this.quote(tableName));
    }

    public String buildChunkedQuerySQL(String tableName, String uniqueKey, Number startUniqueValue) {
        Preconditions.checkNotNull((Object)uniqueKey, (Object)"uniqueKey is null");
        Preconditions.checkNotNull((Object)startUniqueValue, (Object)"startUniqueValue is null");
        return "SELECT * FROM " + this.quote(tableName) + " WHERE " + this.quote(uniqueKey) + " > ? ORDER BY " + this.quote(uniqueKey) + " ASC LIMIT ?";
    }

    public String buildCheckEmptySQL(String tableName) {
        return String.format("SELECT * FROM %s LIMIT 1", this.quote(tableName));
    }

    public String buildSplitByPrimaryKeyRangeSQL(String tableName, String primaryKey) {
        return String.format("SELECT MAX(%s) FROM (SELECT %s FROM %s WHERE %s>=? limit ?) t", this.quote(primaryKey), this.quote(primaryKey), this.quote(tableName), this.quote(primaryKey));
    }

    @Generated
    protected Map<String, Set<String>> getShardingColumnsMap() {
        return this.shardingColumnsMap;
    }
}

