/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.data.pipeline.scenario.rulealtered;

import java.util.Collection;
import java.util.LinkedList;
import lombok.Generated;
import org.apache.commons.lang3.concurrent.ConcurrentException;
import org.apache.commons.lang3.concurrent.LazyInitializer;
import org.apache.shardingsphere.data.pipeline.api.config.rulealtered.JobConfiguration;
import org.apache.shardingsphere.data.pipeline.api.config.rulealtered.TaskConfiguration;
import org.apache.shardingsphere.data.pipeline.api.datasource.PipelineDataSourceWrapper;
import org.apache.shardingsphere.data.pipeline.api.job.JobStatus;
import org.apache.shardingsphere.data.pipeline.api.job.progress.JobProgress;
import org.apache.shardingsphere.data.pipeline.core.datasource.PipelineDataSourceManager;
import org.apache.shardingsphere.data.pipeline.core.metadata.loader.PipelineTableMetaDataLoader;
import org.apache.shardingsphere.data.pipeline.core.task.IncrementalTask;
import org.apache.shardingsphere.data.pipeline.core.task.InventoryTask;
import org.apache.shardingsphere.data.pipeline.scenario.rulealtered.RuleAlteredContext;
import org.apache.shardingsphere.data.pipeline.scenario.rulealtered.RuleAlteredJobPreparer;
import org.apache.shardingsphere.data.pipeline.scenario.rulealtered.RuleAlteredJobWorker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class RuleAlteredJobContext {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(RuleAlteredJobContext.class);
    private final String jobId;
    private final int shardingItem;
    private JobStatus status = JobStatus.RUNNING;
    private JobProgress initProgress;
    private final TaskConfiguration taskConfig;
    private final Collection<InventoryTask> inventoryTasks = new LinkedList<InventoryTask>();
    private final Collection<IncrementalTask> incrementalTasks = new LinkedList<IncrementalTask>();
    private final JobConfiguration jobConfig;
    private final RuleAlteredContext ruleAlteredContext;
    private final PipelineDataSourceManager dataSourceManager = new PipelineDataSourceManager();
    private final LazyInitializer<PipelineDataSourceWrapper> sourceDataSourceLazyInitializer = new LazyInitializer<PipelineDataSourceWrapper>(){

        protected PipelineDataSourceWrapper initialize() {
            return RuleAlteredJobContext.this.dataSourceManager.getDataSource(RuleAlteredJobContext.this.taskConfig.getDumperConfig().getDataSourceConfig());
        }
    };
    private final LazyInitializer<PipelineTableMetaDataLoader> sourceMetaDataLoaderLazyInitializer = new LazyInitializer<PipelineTableMetaDataLoader>(){

        protected PipelineTableMetaDataLoader initialize() throws ConcurrentException {
            return new PipelineTableMetaDataLoader((PipelineDataSourceWrapper)RuleAlteredJobContext.this.sourceDataSourceLazyInitializer.get());
        }
    };
    private RuleAlteredJobPreparer jobPreparer;

    public RuleAlteredJobContext(JobConfiguration jobConfig) {
        this.ruleAlteredContext = RuleAlteredJobWorker.createRuleAlteredContext(jobConfig);
        this.jobConfig = jobConfig;
        jobConfig.buildHandleConfig();
        this.jobId = jobConfig.getHandleConfig().getJobId();
        this.shardingItem = jobConfig.getHandleConfig().getJobShardingItem();
        this.taskConfig = RuleAlteredJobWorker.buildTaskConfig(jobConfig.getPipelineConfig(), jobConfig.getHandleConfig(), this.ruleAlteredContext.getOnRuleAlteredActionConfig());
    }

    public PipelineDataSourceWrapper getSourceDataSource() {
        return (PipelineDataSourceWrapper)this.sourceDataSourceLazyInitializer.get();
    }

    public PipelineTableMetaDataLoader getSourceMetaDataLoader() {
        return (PipelineTableMetaDataLoader)this.sourceMetaDataLoaderLazyInitializer.get();
    }

    public void close() {
        log.info("close...");
        this.dataSourceManager.close();
    }

    @Generated
    public String getJobId() {
        return this.jobId;
    }

    @Generated
    public int getShardingItem() {
        return this.shardingItem;
    }

    @Generated
    public JobStatus getStatus() {
        return this.status;
    }

    @Generated
    public JobProgress getInitProgress() {
        return this.initProgress;
    }

    @Generated
    public TaskConfiguration getTaskConfig() {
        return this.taskConfig;
    }

    @Generated
    public Collection<InventoryTask> getInventoryTasks() {
        return this.inventoryTasks;
    }

    @Generated
    public Collection<IncrementalTask> getIncrementalTasks() {
        return this.incrementalTasks;
    }

    @Generated
    public JobConfiguration getJobConfig() {
        return this.jobConfig;
    }

    @Generated
    public RuleAlteredContext getRuleAlteredContext() {
        return this.ruleAlteredContext;
    }

    @Generated
    public PipelineDataSourceManager getDataSourceManager() {
        return this.dataSourceManager;
    }

    @Generated
    public LazyInitializer<PipelineDataSourceWrapper> getSourceDataSourceLazyInitializer() {
        return this.sourceDataSourceLazyInitializer;
    }

    @Generated
    public LazyInitializer<PipelineTableMetaDataLoader> getSourceMetaDataLoaderLazyInitializer() {
        return this.sourceMetaDataLoaderLazyInitializer;
    }

    @Generated
    public RuleAlteredJobPreparer getJobPreparer() {
        return this.jobPreparer;
    }

    @Generated
    public void setStatus(JobStatus status) {
        this.status = status;
    }

    @Generated
    public void setInitProgress(JobProgress initProgress) {
        this.initProgress = initProgress;
    }

    @Generated
    public void setJobPreparer(RuleAlteredJobPreparer jobPreparer) {
        this.jobPreparer = jobPreparer;
    }
}

