/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.data.pipeline.scenario.rulealtered;

import java.sql.SQLException;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import javax.sql.DataSource;
import lombok.Generated;
import org.apache.shardingsphere.data.pipeline.api.config.rulealtered.JobConfiguration;
import org.apache.shardingsphere.data.pipeline.api.config.rulealtered.TaskConfiguration;
import org.apache.shardingsphere.data.pipeline.api.datanode.JobDataNodeLine;
import org.apache.shardingsphere.data.pipeline.api.datasource.PipelineDataSourceWrapper;
import org.apache.shardingsphere.data.pipeline.api.ingest.position.IngestPosition;
import org.apache.shardingsphere.data.pipeline.api.job.JobStatus;
import org.apache.shardingsphere.data.pipeline.api.job.progress.JobProgress;
import org.apache.shardingsphere.data.pipeline.core.datasource.PipelineDataSourceManager;
import org.apache.shardingsphere.data.pipeline.core.exception.PipelineJobPrepareFailedException;
import org.apache.shardingsphere.data.pipeline.core.execute.ExecuteEngine;
import org.apache.shardingsphere.data.pipeline.core.ingest.position.PositionInitializerFactory;
import org.apache.shardingsphere.data.pipeline.core.metadata.loader.PipelineTableMetaDataLoader;
import org.apache.shardingsphere.data.pipeline.core.prepare.datasource.DataSourcePreparer;
import org.apache.shardingsphere.data.pipeline.core.prepare.datasource.PrepareTargetTablesParameter;
import org.apache.shardingsphere.data.pipeline.core.task.IncrementalTask;
import org.apache.shardingsphere.data.pipeline.core.task.InventoryTask;
import org.apache.shardingsphere.data.pipeline.scenario.rulealtered.RuleAlteredJobContext;
import org.apache.shardingsphere.data.pipeline.scenario.rulealtered.prepare.InventoryTaskSplitter;
import org.apache.shardingsphere.data.pipeline.spi.check.datasource.DataSourceChecker;
import org.apache.shardingsphere.data.pipeline.spi.ingest.channel.PipelineChannelFactory;
import org.apache.shardingsphere.data.pipeline.spi.ingest.position.PositionInitializer;
import org.apache.shardingsphere.scaling.core.job.check.EnvironmentCheckerFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class RuleAlteredJobPreparer {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(RuleAlteredJobPreparer.class);
    private final InventoryTaskSplitter inventoryTaskSplitter = new InventoryTaskSplitter();

    public void prepare(RuleAlteredJobContext jobContext) {
        PipelineDataSourceManager dataSourceManager = jobContext.getDataSourceManager();
        this.prepareTarget(jobContext.getJobConfig(), dataSourceManager);
        this.initAndCheckDataSource(jobContext);
        try {
            this.initIncrementalTasks(jobContext);
            this.initInventoryTasks(jobContext);
            log.info("prepare, jobId={}, shardingItem={}, inventoryTasks={}, incrementalTasks={}", new Object[]{jobContext.getJobId(), jobContext.getShardingItem(), jobContext.getInventoryTasks(), jobContext.getIncrementalTasks()});
        }
        catch (SQLException ex) {
            log.error("Scaling job preparing failed, jobId={}", (Object)jobContext.getJobId());
            throw new PipelineJobPrepareFailedException("Scaling job preparing failed, jobId=" + jobContext.getJobId(), ex);
        }
    }

    private void prepareTarget(JobConfiguration jobConfig, PipelineDataSourceManager dataSourceManager) {
        DataSourcePreparer dataSourcePreparer = EnvironmentCheckerFactory.getDataSourcePreparer(jobConfig.getHandleConfig().getTargetDatabaseType());
        if (null == dataSourcePreparer) {
            log.info("dataSourcePreparer null, ignore prepare target");
            return;
        }
        JobDataNodeLine tablesFirstDataNodes = JobDataNodeLine.unmarshal((String)jobConfig.getHandleConfig().getTablesFirstDataNodes());
        PrepareTargetTablesParameter prepareTargetTablesParameter = new PrepareTargetTablesParameter(tablesFirstDataNodes, jobConfig.getPipelineConfig(), dataSourceManager);
        dataSourcePreparer.prepareTargetTables(prepareTargetTablesParameter);
    }

    private void initAndCheckDataSource(RuleAlteredJobContext jobContext) {
        PipelineDataSourceManager dataSourceManager = jobContext.getDataSourceManager();
        TaskConfiguration taskConfig = jobContext.getTaskConfig();
        PipelineDataSourceWrapper sourceDataSource = dataSourceManager.getDataSource(taskConfig.getDumperConfig().getDataSourceConfig());
        PipelineDataSourceWrapper targetDataSource = dataSourceManager.getDataSource(taskConfig.getImporterConfig().getDataSourceConfig());
        this.checkSourceDataSource(jobContext, sourceDataSource);
        JobProgress initProgress = jobContext.getInitProgress();
        if (null == initProgress || initProgress.getStatus() == JobStatus.PREPARING_FAILURE) {
            this.checkTargetDataSource(jobContext, targetDataSource);
        }
    }

    private void checkSourceDataSource(RuleAlteredJobContext jobContext, PipelineDataSourceWrapper sourceDataSource) {
        DataSourceChecker dataSourceChecker = EnvironmentCheckerFactory.newInstance(jobContext.getJobConfig().getHandleConfig().getSourceDatabaseType());
        Set<PipelineDataSourceWrapper> sourceDataSources = Collections.singleton(sourceDataSource);
        dataSourceChecker.checkConnection(sourceDataSources);
        dataSourceChecker.checkPrivilege(sourceDataSources);
        dataSourceChecker.checkVariable(sourceDataSources);
    }

    private void checkTargetDataSource(RuleAlteredJobContext jobContext, PipelineDataSourceWrapper targetDataSource) {
        DataSourceChecker dataSourceChecker = EnvironmentCheckerFactory.newInstance(jobContext.getJobConfig().getHandleConfig().getTargetDatabaseType());
        List<PipelineDataSourceWrapper> targetDataSources = Collections.singletonList(targetDataSource);
        dataSourceChecker.checkConnection(targetDataSources);
        dataSourceChecker.checkTargetTable(targetDataSources, jobContext.getTaskConfig().getImporterConfig().getShardingColumnsMap().keySet());
    }

    private void initInventoryTasks(RuleAlteredJobContext jobContext) {
        List<InventoryTask> allInventoryTasks = this.inventoryTaskSplitter.splitInventoryData(jobContext);
        jobContext.getInventoryTasks().addAll(allInventoryTasks);
    }

    private void initIncrementalTasks(RuleAlteredJobContext jobContext) throws SQLException {
        PipelineChannelFactory pipelineChannelFactory = jobContext.getRuleAlteredContext().getPipelineChannelFactory();
        ExecuteEngine incrementalDumperExecuteEngine = jobContext.getRuleAlteredContext().getIncrementalDumperExecuteEngine();
        TaskConfiguration taskConfig = jobContext.getTaskConfig();
        PipelineDataSourceManager dataSourceManager = jobContext.getDataSourceManager();
        taskConfig.getDumperConfig().setPosition(this.getIncrementalPosition(jobContext, taskConfig, dataSourceManager));
        PipelineTableMetaDataLoader sourceMetaDataLoader = jobContext.getSourceMetaDataLoader();
        IncrementalTask incrementalTask = new IncrementalTask(taskConfig.getHandleConfig().getConcurrency(), taskConfig.getDumperConfig(), taskConfig.getImporterConfig(), pipelineChannelFactory, dataSourceManager, sourceMetaDataLoader, incrementalDumperExecuteEngine);
        jobContext.getIncrementalTasks().add(incrementalTask);
    }

    private IngestPosition<?> getIncrementalPosition(RuleAlteredJobContext jobContext, TaskConfiguration taskConfig, PipelineDataSourceManager dataSourceManager) throws SQLException {
        Optional positionOptional;
        if (null != jobContext.getInitProgress() && (positionOptional = jobContext.getInitProgress().getIncrementalPosition(taskConfig.getDumperConfig().getDataSourceName())).isPresent()) {
            return (IngestPosition)positionOptional.get();
        }
        String databaseType = taskConfig.getHandleConfig().getSourceDatabaseType();
        PipelineDataSourceWrapper dataSource = dataSourceManager.getDataSource(taskConfig.getDumperConfig().getDataSourceConfig());
        return PositionInitializerFactory.getPositionInitializer(databaseType).init((DataSource)dataSource);
    }

    public void cleanup(RuleAlteredJobContext jobContext) {
        PipelineDataSourceManager dataSourceManager = jobContext.getDataSourceManager();
        try {
            TaskConfiguration taskConfig = jobContext.getTaskConfig();
            PositionInitializer positionInitializer = PositionInitializerFactory.getPositionInitializer(taskConfig.getHandleConfig().getSourceDatabaseType());
            positionInitializer.destroy((DataSource)dataSourceManager.getDataSource(taskConfig.getDumperConfig().getDataSourceConfig()));
        }
        catch (SQLException ex) {
            log.warn("Scaling job destroying failed", (Throwable)ex);
        }
    }
}

