/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.data.pipeline.scenario.rulealtered;

import lombok.Generated;
import org.apache.shardingsphere.data.pipeline.api.ingest.position.FinishedPosition;
import org.apache.shardingsphere.data.pipeline.api.job.JobStatus;
import org.apache.shardingsphere.data.pipeline.core.execute.ExecuteCallback;
import org.apache.shardingsphere.data.pipeline.core.task.IncrementalTask;
import org.apache.shardingsphere.data.pipeline.core.task.InventoryTask;
import org.apache.shardingsphere.data.pipeline.scenario.rulealtered.RuleAlteredJobContext;
import org.apache.shardingsphere.data.pipeline.scenario.rulealtered.RuleAlteredJobPreparer;
import org.apache.shardingsphere.data.pipeline.scenario.rulealtered.RuleAlteredJobProgressDetector;
import org.apache.shardingsphere.infra.eventbus.ShardingSphereEventBus;
import org.apache.shardingsphere.mode.manager.cluster.coordinator.registry.config.event.rule.ScalingReleaseSchemaNameLockEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class RuleAlteredJobScheduler
implements Runnable {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(RuleAlteredJobScheduler.class);
    private final RuleAlteredJobContext jobContext;

    public void start() {
        new Thread(this).start();
    }

    public void stop() {
        boolean almostFinished;
        log.info("stop job {}", (Object)this.jobContext.getJobId());
        boolean bl = almostFinished = this.jobContext.getStatus() == JobStatus.ALMOST_FINISHED;
        if (almostFinished) {
            log.info("almost finished, preparer cleanup, job {}", (Object)this.jobContext.getJobId());
            RuleAlteredJobPreparer jobPreparer = this.jobContext.getJobPreparer();
            if (null != jobPreparer) {
                jobPreparer.cleanup(this.jobContext);
            }
        }
        for (InventoryTask inventoryTask : this.jobContext.getInventoryTasks()) {
            log.info("stop inventory task {} - {}", (Object)this.jobContext.getJobId(), (Object)inventoryTask.getTaskId());
            inventoryTask.stop();
            inventoryTask.close();
        }
        for (IncrementalTask incrementalTask : this.jobContext.getIncrementalTasks()) {
            log.info("stop incremental task {} - {}", (Object)this.jobContext.getJobId(), (Object)incrementalTask.getTaskId());
            incrementalTask.stop();
            incrementalTask.close();
        }
        this.jobContext.close();
    }

    @Override
    public void run() {
        if (this.executeInventoryTask()) {
            this.executeIncrementalTask();
        }
    }

    private synchronized boolean executeInventoryTask() {
        if (RuleAlteredJobProgressDetector.allInventoryTasksFinished(this.jobContext.getInventoryTasks())) {
            log.info("All inventory tasks finished.");
            return true;
        }
        log.info("-------------- Start inventory task --------------");
        this.jobContext.setStatus(JobStatus.EXECUTE_INVENTORY_TASK);
        ExecuteCallback inventoryTaskCallback = this.createInventoryTaskCallback();
        for (InventoryTask each : this.jobContext.getInventoryTasks()) {
            if (each.getProgress().getPosition() instanceof FinishedPosition) continue;
            this.jobContext.getRuleAlteredContext().getInventoryDumperExecuteEngine().submit(each, inventoryTaskCallback);
        }
        return false;
    }

    private ExecuteCallback createInventoryTaskCallback() {
        return new ExecuteCallback(){

            @Override
            public void onSuccess() {
                if (RuleAlteredJobProgressDetector.allInventoryTasksFinished(RuleAlteredJobScheduler.this.jobContext.getInventoryTasks())) {
                    log.info("onSuccess, all inventory tasks finished.");
                    RuleAlteredJobScheduler.this.executeIncrementalTask();
                }
            }

            @Override
            public void onFailure(Throwable throwable) {
                log.error("Inventory task execute failed.", throwable);
                RuleAlteredJobScheduler.this.stop();
                RuleAlteredJobScheduler.this.jobContext.setStatus(JobStatus.EXECUTE_INVENTORY_TASK_FAILURE);
                ScalingReleaseSchemaNameLockEvent event = new ScalingReleaseSchemaNameLockEvent(RuleAlteredJobScheduler.this.jobContext.getJobConfig().getWorkflowConfig().getSchemaName());
                ShardingSphereEventBus.getInstance().post((Object)event);
            }
        };
    }

    private synchronized void executeIncrementalTask() {
        if (JobStatus.EXECUTE_INCREMENTAL_TASK == this.jobContext.getStatus()) {
            log.info("job status already EXECUTE_INCREMENTAL_TASK, ignore");
            return;
        }
        log.info("-------------- Start incremental task --------------");
        this.jobContext.setStatus(JobStatus.EXECUTE_INCREMENTAL_TASK);
        ExecuteCallback incrementalTaskCallback = this.createIncrementalTaskCallback();
        for (IncrementalTask each : this.jobContext.getIncrementalTasks()) {
            if (each.getProgress().getPosition() instanceof FinishedPosition) continue;
            this.jobContext.getRuleAlteredContext().getIncrementalDumperExecuteEngine().submit(each, incrementalTaskCallback);
        }
    }

    private ExecuteCallback createIncrementalTaskCallback() {
        return new ExecuteCallback(){

            @Override
            public void onSuccess() {
            }

            @Override
            public void onFailure(Throwable throwable) {
                log.error("Incremental task execute failed.", throwable);
                RuleAlteredJobScheduler.this.stop();
                RuleAlteredJobScheduler.this.jobContext.setStatus(JobStatus.EXECUTE_INCREMENTAL_TASK_FAILURE);
                ScalingReleaseSchemaNameLockEvent event = new ScalingReleaseSchemaNameLockEvent(RuleAlteredJobScheduler.this.jobContext.getJobConfig().getWorkflowConfig().getSchemaName());
                ShardingSphereEventBus.getInstance().post((Object)event);
            }
        };
    }

    @Generated
    public RuleAlteredJobScheduler(RuleAlteredJobContext jobContext) {
        this.jobContext = jobContext;
    }

    @Generated
    public RuleAlteredJobContext getJobContext() {
        return this.jobContext;
    }
}

