/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.data.pipeline.scenario.rulealtered;

import com.google.common.eventbus.Subscribe;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Function;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.shardingsphere.data.pipeline.api.PipelineJobAPIFactory;
import org.apache.shardingsphere.data.pipeline.api.config.rulealtered.HandleConfiguration;
import org.apache.shardingsphere.data.pipeline.api.config.rulealtered.JobConfiguration;
import org.apache.shardingsphere.data.pipeline.api.config.rulealtered.PipelineConfiguration;
import org.apache.shardingsphere.data.pipeline.api.config.rulealtered.TaskConfiguration;
import org.apache.shardingsphere.data.pipeline.api.config.rulealtered.WorkflowConfiguration;
import org.apache.shardingsphere.data.pipeline.api.datasource.config.PipelineDataSourceConfiguration;
import org.apache.shardingsphere.data.pipeline.api.datasource.config.PipelineDataSourceConfigurationFactory;
import org.apache.shardingsphere.data.pipeline.api.datasource.config.impl.ShardingSpherePipelineDataSourceConfiguration;
import org.apache.shardingsphere.data.pipeline.api.datasource.config.yaml.YamlPipelineDataSourceConfiguration;
import org.apache.shardingsphere.data.pipeline.api.job.JobStatus;
import org.apache.shardingsphere.data.pipeline.api.pojo.JobInfo;
import org.apache.shardingsphere.data.pipeline.core.exception.PipelineJobCreationException;
import org.apache.shardingsphere.data.pipeline.core.execute.FinishedCheckJobExecutor;
import org.apache.shardingsphere.data.pipeline.core.execute.PipelineJobExecutor;
import org.apache.shardingsphere.data.pipeline.core.lock.ScalingSchemaNameDistributeLock;
import org.apache.shardingsphere.data.pipeline.scenario.rulealtered.RuleAlteredContext;
import org.apache.shardingsphere.data.pipeline.spi.rulealtered.RuleAlteredDetector;
import org.apache.shardingsphere.data.pipeline.spi.rulealtered.RuleAlteredJobConfigurationPreparer;
import org.apache.shardingsphere.infra.config.RuleConfiguration;
import org.apache.shardingsphere.infra.config.rulealtered.OnRuleAlteredActionConfiguration;
import org.apache.shardingsphere.infra.database.metadata.url.JdbcUrlAppender;
import org.apache.shardingsphere.infra.database.type.DatabaseType;
import org.apache.shardingsphere.infra.database.type.DatabaseTypeRegistry;
import org.apache.shardingsphere.infra.database.type.dialect.MySQLDatabaseType;
import org.apache.shardingsphere.infra.eventbus.ShardingSphereEventBus;
import org.apache.shardingsphere.infra.yaml.config.pojo.YamlRootConfiguration;
import org.apache.shardingsphere.infra.yaml.config.pojo.YamlRuleConfiguration;
import org.apache.shardingsphere.infra.yaml.config.swapper.YamlRuleConfigurationSwapperEngine;
import org.apache.shardingsphere.infra.yaml.engine.YamlEngine;
import org.apache.shardingsphere.mode.manager.cluster.coordinator.registry.cache.event.StartScalingEvent;
import org.apache.shardingsphere.mode.manager.cluster.coordinator.registry.config.event.rule.ScalingReleaseSchemaNameLockEvent;
import org.apache.shardingsphere.mode.manager.cluster.coordinator.registry.config.event.rule.ScalingTaskFinishedEvent;
import org.apache.shardingsphere.spi.required.RequiredSPIRegistry;
import org.apache.shardingsphere.spi.singleton.SingletonSPIRegistry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class RuleAlteredJobWorker {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(RuleAlteredJobWorker.class);
    private static final RuleAlteredJobWorker INSTANCE = new RuleAlteredJobWorker();
    private static final Map<String, RuleAlteredDetector> RULE_CLASS_NAME_DETECTOR_MAP = SingletonSPIRegistry.getSingletonInstancesMap(RuleAlteredDetector.class, RuleAlteredDetector::getRuleConfigClassName);
    private static final Map<String, RuleAlteredDetector> YAML_RULE_CLASS_NAME_DETECTOR_MAP = SingletonSPIRegistry.getSingletonInstancesMap(RuleAlteredDetector.class, RuleAlteredDetector::getYamlRuleConfigClassName);
    private static final YamlRuleConfigurationSwapperEngine SWAPPER_ENGINE = new YamlRuleConfigurationSwapperEngine();
    private static final AtomicBoolean WORKER_INITIALIZED = new AtomicBoolean(false);

    public static boolean isOnRuleAlteredActionEnabled(RuleConfiguration ruleConfig) {
        if (null == ruleConfig) {
            return false;
        }
        RuleAlteredDetector detector = RULE_CLASS_NAME_DETECTOR_MAP.get(ruleConfig.getClass().getName());
        return null != detector && detector.getOnRuleAlteredActionConfig(ruleConfig).isPresent();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void initWorkerIfNecessary() {
        if (WORKER_INITIALIZED.get()) {
            return;
        }
        AtomicBoolean atomicBoolean = WORKER_INITIALIZED;
        synchronized (atomicBoolean) {
            if (WORKER_INITIALIZED.get()) {
                return;
            }
            log.info("start worker initialization");
            ShardingSphereEventBus.getInstance().register((Object)INSTANCE);
            new FinishedCheckJobExecutor().start();
            new PipelineJobExecutor().start();
            WORKER_INITIALIZED.set(true);
            log.info("worker initialization done");
        }
    }

    public static RuleAlteredContext createRuleAlteredContext(JobConfiguration jobConfig) {
        YamlRootConfiguration targetRootConfig = RuleAlteredJobWorker.getYamlRootConfig(jobConfig);
        YamlRuleConfiguration yamlRuleConfig = null;
        for (YamlRuleConfiguration each : targetRootConfig.getRules()) {
            if (!jobConfig.getWorkflowConfig().getAlteredRuleYamlClassNames().contains(each.getClass().getName())) continue;
            yamlRuleConfig = each;
            break;
        }
        if (null == yamlRuleConfig) {
            throw new PipelineJobCreationException("could not find altered rule");
        }
        RuleConfiguration ruleConfig = SWAPPER_ENGINE.swapToRuleConfiguration(yamlRuleConfig);
        RuleAlteredDetector detector = RULE_CLASS_NAME_DETECTOR_MAP.get(ruleConfig.getClass().getName());
        Optional onRuleAlteredActionConfigOptional = detector.getOnRuleAlteredActionConfig(ruleConfig);
        if (!onRuleAlteredActionConfigOptional.isPresent()) {
            log.error("rule altered action enabled but actor is not configured, ignored, ruleConfig={}", (Object)ruleConfig);
            throw new PipelineJobCreationException("rule altered actor not configured");
        }
        return new RuleAlteredContext((OnRuleAlteredActionConfiguration)onRuleAlteredActionConfigOptional.get());
    }

    private static YamlRootConfiguration getYamlRootConfig(JobConfiguration jobConfig) {
        PipelineDataSourceConfiguration targetDataSourceConfig = PipelineDataSourceConfigurationFactory.newInstance((String)jobConfig.getPipelineConfig().getTarget().getType(), (String)jobConfig.getPipelineConfig().getTarget().getParameter());
        if (targetDataSourceConfig instanceof ShardingSpherePipelineDataSourceConfiguration) {
            return ((ShardingSpherePipelineDataSourceConfiguration)targetDataSourceConfig).getRootConfig();
        }
        PipelineDataSourceConfiguration sourceDataSourceConfig = PipelineDataSourceConfigurationFactory.newInstance((String)jobConfig.getPipelineConfig().getSource().getType(), (String)jobConfig.getPipelineConfig().getSource().getParameter());
        return ((ShardingSpherePipelineDataSourceConfiguration)sourceDataSourceConfig).getRootConfig();
    }

    @Subscribe
    public void start(StartScalingEvent event) {
        Optional jobId;
        if (!this.isUncompletedJobOfSameSchemaInJobList(event.getSchemaName())) {
            log.warn("There is an outstanding job with the same schema name");
            return;
        }
        log.info("Start scaling job by {}", (Object)event);
        Optional<JobConfiguration> jobConfigOptional = this.createJobConfig(event);
        Optional optional = jobId = jobConfigOptional.isPresent() ? PipelineJobAPIFactory.getRuleAlteredJobAPI().start(jobConfigOptional.get()) : Optional.empty();
        if (!jobId.isPresent()) {
            log.info("Switch rule configuration immediately.");
            YamlRootConfiguration targetRootConfig = this.getYamlRootConfiguration(event.getSchemaName(), event.getTargetDataSource(), event.getTargetRule());
            ScalingTaskFinishedEvent taskFinishedEvent = new ScalingTaskFinishedEvent(event.getSchemaName(), targetRootConfig, event.getRuleCacheId());
            ShardingSphereEventBus.getInstance().post((Object)taskFinishedEvent);
        }
    }

    private Optional<JobConfiguration> createJobConfig(StartScalingEvent event) {
        YamlRootConfiguration sourceRootConfig = this.getYamlRootConfiguration(event.getSchemaName(), event.getSourceDataSource(), event.getSourceRule());
        YamlRootConfiguration targetRootConfig = this.getYamlRootConfiguration(event.getSchemaName(), event.getTargetDataSource(), event.getTargetRule());
        LinkedHashSet<String> alteredRuleYamlClassNames = new LinkedHashSet<String>();
        for (Pair<YamlRuleConfiguration, YamlRuleConfiguration> each : this.groupSourceTargetRuleConfigsByType(sourceRootConfig.getRules(), targetRootConfig.getRules())) {
            String type = (null != each.getLeft() ? (YamlRuleConfiguration)each.getLeft() : (YamlRuleConfiguration)each.getRight()).getClass().getName();
            RuleAlteredDetector detector = YAML_RULE_CLASS_NAME_DETECTOR_MAP.get(type);
            if (null == detector) continue;
            boolean ruleAltered = detector.isRuleAltered((YamlRuleConfiguration)each.getLeft(), (YamlRuleConfiguration)each.getRight());
            log.info("type={}, ruleAltered={}", (Object)type, (Object)ruleAltered);
            if (!ruleAltered) continue;
            alteredRuleYamlClassNames.add(type);
        }
        if (alteredRuleYamlClassNames.isEmpty()) {
            log.error("no altered rule");
            throw new PipelineJobCreationException("no altered rule");
        }
        if (alteredRuleYamlClassNames.size() > 1) {
            log.error("more than 1 rule altered");
            throw new PipelineJobCreationException("more than 1 rule altered");
        }
        WorkflowConfiguration workflowConfig = new WorkflowConfiguration(event.getSchemaName(), new ArrayList(alteredRuleYamlClassNames), event.getRuleCacheId());
        PipelineConfiguration pipelineConfig = this.getPipelineConfiguration(sourceRootConfig, targetRootConfig);
        return Optional.of(new JobConfiguration(workflowConfig, pipelineConfig));
    }

    private Collection<Pair<YamlRuleConfiguration, YamlRuleConfiguration>> groupSourceTargetRuleConfigsByType(Collection<YamlRuleConfiguration> sourceRules, Collection<YamlRuleConfiguration> targetRules) {
        Map sourceRulesMap = sourceRules.stream().collect(Collectors.toMap(Object::getClass, Function.identity()));
        Map targetRulesMap = targetRules.stream().collect(Collectors.toMap(Object::getClass, Function.identity()));
        LinkedList<Pair<YamlRuleConfiguration, YamlRuleConfiguration>> result = new LinkedList<Pair<YamlRuleConfiguration, YamlRuleConfiguration>>();
        for (Map.Entry entry : sourceRulesMap.entrySet()) {
            YamlRuleConfiguration targetRule = (YamlRuleConfiguration)targetRulesMap.get(entry.getKey());
            result.add((Pair<YamlRuleConfiguration, YamlRuleConfiguration>)Pair.of(entry.getValue(), (Object)targetRule));
        }
        for (Map.Entry entry : targetRulesMap.entrySet()) {
            if (sourceRulesMap.containsKey(entry.getKey())) continue;
            result.add((Pair<YamlRuleConfiguration, YamlRuleConfiguration>)Pair.of(null, entry.getValue()));
        }
        return result;
    }

    private PipelineConfiguration getPipelineConfiguration(YamlRootConfiguration sourceRootConfig, YamlRootConfiguration targetRootConfig) {
        PipelineConfiguration result = new PipelineConfiguration();
        result.setSource(this.createYamlPipelineDataSourceConfiguration(sourceRootConfig));
        result.setTarget(this.createYamlPipelineDataSourceConfiguration(targetRootConfig));
        return result;
    }

    private YamlPipelineDataSourceConfiguration createYamlPipelineDataSourceConfiguration(YamlRootConfiguration yamlConfig) {
        ShardingSpherePipelineDataSourceConfiguration config = new ShardingSpherePipelineDataSourceConfiguration(yamlConfig);
        YamlPipelineDataSourceConfiguration result = new YamlPipelineDataSourceConfiguration();
        result.setType(config.getType());
        result.setParameter(config.getParameter());
        return result;
    }

    private YamlRootConfiguration getYamlRootConfiguration(String schemaName, String dataSources, String rules) {
        YamlRootConfiguration result = new YamlRootConfiguration();
        result.setSchemaName(schemaName);
        Map yamlDataSources = (Map)YamlEngine.unmarshal((String)dataSources, Map.class);
        this.disableSSLForMySQL(yamlDataSources);
        result.setDataSources(yamlDataSources);
        Collection yamlRuleConfigs = (Collection)YamlEngine.unmarshal((String)rules, Collection.class, (boolean)true);
        result.setRules(yamlRuleConfigs);
        return result;
    }

    private void disableSSLForMySQL(Map<String, Map<String, Object>> yamlDataSources) {
        Map<String, Object> firstDataSourceProps;
        String jdbcUrlKey = (firstDataSourceProps = yamlDataSources.entrySet().iterator().next().getValue()).containsKey("url") ? "url" : "jdbcUrl";
        String jdbcUrl = (String)firstDataSourceProps.get(jdbcUrlKey);
        if (null == jdbcUrl) {
            log.warn("disableSSLForMySQL, could not get jdbcUrl, jdbcUrlKey={}", (Object)jdbcUrlKey);
            return;
        }
        DatabaseType databaseType = DatabaseTypeRegistry.getDatabaseTypeByURL((String)jdbcUrl);
        if (!(databaseType instanceof MySQLDatabaseType)) {
            return;
        }
        Properties queryProps = new Properties();
        queryProps.setProperty("useSSL", Boolean.FALSE.toString());
        for (Map.Entry<String, Map<String, Object>> entry : yamlDataSources.entrySet()) {
            entry.getValue().put(jdbcUrlKey, new JdbcUrlAppender().appendQueryProperties((String)entry.getValue().get(jdbcUrlKey), queryProps));
        }
    }

    public static TaskConfiguration buildTaskConfig(PipelineConfiguration pipelineConfig, HandleConfiguration handleConfig, OnRuleAlteredActionConfiguration onRuleAlteredActionConfig) {
        RuleAlteredJobConfigurationPreparer preparer = (RuleAlteredJobConfigurationPreparer)RequiredSPIRegistry.getRegisteredService(RuleAlteredJobConfigurationPreparer.class);
        return preparer.createTaskConfiguration(pipelineConfig, handleConfig, onRuleAlteredActionConfig);
    }

    private boolean isUncompletedJobOfSameSchemaInJobList(String schema) {
        boolean isUncompletedJobOfSameSchema = false;
        for (JobInfo each : PipelineJobAPIFactory.getRuleAlteredJobAPI().list()) {
            JobConfiguration jobConfiguration;
            if (PipelineJobAPIFactory.getRuleAlteredJobAPI().getProgress(each.getJobId()).values().stream().allMatch(progress -> progress.getStatus().equals((Object)JobStatus.FINISHED)) || !this.isUncompletedJobOfSameSchema(jobConfiguration = (JobConfiguration)YamlEngine.unmarshal((String)each.getJobParameter(), JobConfiguration.class, (boolean)true), each.getJobId(), schema)) continue;
            isUncompletedJobOfSameSchema = true;
            break;
        }
        return !isUncompletedJobOfSameSchema;
    }

    private boolean isUncompletedJobOfSameSchema(JobConfiguration jobConfig, String jobId, String currentSchema) {
        WorkflowConfiguration workflowConfig;
        HandleConfiguration handleConfig = jobConfig.getHandleConfig();
        if (null == handleConfig || null == (workflowConfig = jobConfig.getWorkflowConfig())) {
            log.warn("handleConfig or workflowConfig null, jobId={}", (Object)jobId);
            return false;
        }
        return currentSchema.equals(workflowConfig.getSchemaName());
    }

    @Subscribe
    public void scalingReleaseSchemaNameLock(ScalingReleaseSchemaNameLockEvent event) {
        ScalingSchemaNameDistributeLock.getInstance().releaseLock(event.getSchemaName());
    }
}

