/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.scaling.core.job.dumper;

import java.lang.reflect.Constructor;
import javax.sql.DataSource;
import lombok.Generated;
import org.apache.shardingsphere.data.pipeline.api.config.ingest.DumperConfiguration;
import org.apache.shardingsphere.data.pipeline.api.config.ingest.InventoryDumperConfiguration;
import org.apache.shardingsphere.data.pipeline.api.ingest.channel.PipelineChannel;
import org.apache.shardingsphere.data.pipeline.api.ingest.position.IngestPosition;
import org.apache.shardingsphere.data.pipeline.core.metadata.loader.PipelineTableMetaDataLoader;
import org.apache.shardingsphere.data.pipeline.spi.ingest.dumper.IncrementalDumper;
import org.apache.shardingsphere.data.pipeline.spi.ingest.dumper.InventoryDumper;
import org.apache.shardingsphere.scaling.core.spi.ScalingEntry;
import org.apache.shardingsphere.scaling.core.spi.ScalingEntryLoader;

public final class DumperFactory {
    public static InventoryDumper createInventoryDumper(InventoryDumperConfiguration inventoryDumperConfig, PipelineChannel channel, DataSource sourceDataSource, PipelineTableMetaDataLoader sourceMetaDataLoader) {
        ScalingEntry scalingEntry = ScalingEntryLoader.getInstance(inventoryDumperConfig.getDataSourceConfig().getDatabaseType().getName());
        Constructor<? extends InventoryDumper> constructor = scalingEntry.getInventoryDumperClass().getConstructor(InventoryDumperConfiguration.class, PipelineChannel.class, DataSource.class, PipelineTableMetaDataLoader.class);
        return constructor.newInstance(inventoryDumperConfig, channel, sourceDataSource, sourceMetaDataLoader);
    }

    public static IncrementalDumper createIncrementalDumper(DumperConfiguration dumperConfig, IngestPosition<?> position, PipelineChannel channel, PipelineTableMetaDataLoader sourceMetaDataLoader) {
        String databaseType = dumperConfig.getDataSourceConfig().getDatabaseType().getName();
        ScalingEntry scalingEntry = ScalingEntryLoader.getInstance(databaseType);
        Constructor<? extends IncrementalDumper> constructor = scalingEntry.getIncrementalDumperClass().getConstructor(DumperConfiguration.class, IngestPosition.class, PipelineChannel.class, PipelineTableMetaDataLoader.class);
        return constructor.newInstance(dumperConfig, position, channel, sourceMetaDataLoader);
    }

    @Generated
    private DumperFactory() {
    }
}

