/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.data.pipeline.core.api.impl;

import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Properties;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import lombok.Generated;
import org.apache.shardingsphere.data.pipeline.api.InventoryIncrementalJobPublicAPI;
import org.apache.shardingsphere.data.pipeline.api.check.consistency.DataConsistencyCheckResult;
import org.apache.shardingsphere.data.pipeline.api.check.consistency.PipelineDataConsistencyChecker;
import org.apache.shardingsphere.data.pipeline.api.config.job.PipelineJobConfiguration;
import org.apache.shardingsphere.data.pipeline.api.config.process.PipelineProcessConfiguration;
import org.apache.shardingsphere.data.pipeline.api.context.PipelineJobItemContext;
import org.apache.shardingsphere.data.pipeline.api.job.JobStatus;
import org.apache.shardingsphere.data.pipeline.api.job.progress.InventoryIncrementalJobItemProgress;
import org.apache.shardingsphere.data.pipeline.api.pojo.DataConsistencyCheckAlgorithmInfo;
import org.apache.shardingsphere.data.pipeline.core.api.InventoryIncrementalJobAPI;
import org.apache.shardingsphere.data.pipeline.core.api.impl.AbstractPipelineJobAPIImpl;
import org.apache.shardingsphere.data.pipeline.core.api.impl.InventoryIncrementalJobItemAPIImpl;
import org.apache.shardingsphere.data.pipeline.core.api.impl.PipelineProcessConfigurationPersistService;
import org.apache.shardingsphere.data.pipeline.core.check.consistency.DataConsistencyCalculateAlgorithmChooser;
import org.apache.shardingsphere.data.pipeline.core.config.process.PipelineProcessConfigurationUtil;
import org.apache.shardingsphere.data.pipeline.core.context.InventoryIncrementalProcessContext;
import org.apache.shardingsphere.data.pipeline.core.exception.metadata.AlterNotExistProcessConfigurationException;
import org.apache.shardingsphere.data.pipeline.core.exception.metadata.CreateExistsProcessConfigurationException;
import org.apache.shardingsphere.data.pipeline.scenario.consistencycheck.ConsistencyCheckJobItemContext;
import org.apache.shardingsphere.data.pipeline.spi.check.consistency.DataConsistencyCalculateAlgorithm;
import org.apache.shardingsphere.data.pipeline.spi.check.consistency.DataConsistencyCalculateAlgorithmFactory;
import org.apache.shardingsphere.data.pipeline.yaml.process.YamlPipelineProcessConfiguration;
import org.apache.shardingsphere.data.pipeline.yaml.process.YamlPipelineProcessConfigurationSwapper;
import org.apache.shardingsphere.elasticjob.infra.pojo.JobConfigurationPOJO;
import org.apache.shardingsphere.infra.database.type.DatabaseTypeFactory;
import org.apache.shardingsphere.infra.util.exception.ShardingSpherePreconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractInventoryIncrementalJobAPIImpl
extends AbstractPipelineJobAPIImpl
implements InventoryIncrementalJobAPI,
InventoryIncrementalJobPublicAPI {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AbstractInventoryIncrementalJobAPIImpl.class);
    private final YamlPipelineProcessConfigurationSwapper swapper = new YamlPipelineProcessConfigurationSwapper();
    private final PipelineProcessConfigurationPersistService processConfigPersistService = new PipelineProcessConfigurationPersistService();
    private final InventoryIncrementalJobItemAPIImpl jobItemAPI = new InventoryIncrementalJobItemAPIImpl();

    protected abstract String getTargetDatabaseType(PipelineJobConfiguration var1);

    @Override
    public abstract InventoryIncrementalProcessContext buildPipelineProcessContext(PipelineJobConfiguration var1);

    public void createProcessConfiguration(PipelineProcessConfiguration processConfig) {
        PipelineProcessConfiguration existingProcessConfig = this.processConfigPersistService.load(this.getJobType());
        ShardingSpherePreconditions.checkState((null == existingProcessConfig ? 1 : 0) != 0, CreateExistsProcessConfigurationException::new);
        this.processConfigPersistService.persist(this.getJobType(), processConfig);
    }

    public void alterProcessConfiguration(PipelineProcessConfiguration processConfig) {
        YamlPipelineProcessConfiguration targetYamlProcessConfig = this.getTargetYamlProcessConfiguration();
        targetYamlProcessConfig.copyNonNullFields(this.swapper.swapToYamlConfiguration(processConfig));
        this.processConfigPersistService.persist(this.getJobType(), this.swapper.swapToObject(targetYamlProcessConfig));
    }

    private YamlPipelineProcessConfiguration getTargetYamlProcessConfiguration() {
        PipelineProcessConfiguration existingProcessConfig = this.processConfigPersistService.load(this.getJobType());
        ShardingSpherePreconditions.checkNotNull((Object)existingProcessConfig, AlterNotExistProcessConfigurationException::new);
        return this.swapper.swapToYamlConfiguration(existingProcessConfig);
    }

    public void dropProcessConfiguration(String confPath) {
        String finalConfPath = confPath.trim();
        PipelineProcessConfigurationUtil.verifyConfPath(confPath);
        YamlPipelineProcessConfiguration targetYamlProcessConfig = this.getTargetYamlProcessConfiguration();
        PipelineProcessConfigurationUtil.setFieldsNullByConfPath(targetYamlProcessConfig, finalConfPath);
        this.processConfigPersistService.persist(this.getJobType(), this.swapper.swapToObject(targetYamlProcessConfig));
    }

    public PipelineProcessConfiguration showProcessConfiguration() {
        PipelineProcessConfiguration result = this.processConfigPersistService.load(this.getJobType());
        result = PipelineProcessConfigurationUtil.convertWithDefaultValue(result);
        return result;
    }

    public Map<Integer, InventoryIncrementalJobItemProgress> getJobProgress(String jobId) {
        this.checkModeConfig();
        return this.getJobProgress(this.getJobConfiguration(jobId));
    }

    @Override
    public Map<Integer, InventoryIncrementalJobItemProgress> getJobProgress(PipelineJobConfiguration jobConfig) {
        String jobId = jobConfig.getJobId();
        JobConfigurationPOJO jobConfigPOJO = this.getElasticJobConfigPOJO(jobId);
        return IntStream.range(0, jobConfig.getJobShardingCount()).boxed().collect(LinkedHashMap::new, (map, each) -> {
            InventoryIncrementalJobItemProgress jobItemProgress = this.getJobItemProgress(jobId, (int)each);
            if (null != jobItemProgress) {
                jobItemProgress.setActive(!jobConfigPOJO.isDisabled());
                jobItemProgress.setErrorMessage(this.getJobItemErrorMessage(jobId, (int)each));
            }
            map.put(each, jobItemProgress);
        }, HashMap::putAll);
    }

    @Override
    public InventoryIncrementalJobItemProgress getJobItemProgress(String jobId, int shardingItem) {
        return this.jobItemAPI.getJobItemProgress(jobId, shardingItem);
    }

    @Override
    public void persistJobItemProgress(PipelineJobItemContext jobItemContext) {
        this.jobItemAPI.persistJobItemProgress(jobItemContext);
    }

    @Override
    public void updateJobItemStatus(String jobId, int shardingItem, JobStatus status) {
        this.jobItemAPI.updateJobItemStatus(jobId, shardingItem, status);
    }

    public Collection<DataConsistencyCheckAlgorithmInfo> listDataConsistencyCheckAlgorithms() {
        this.checkModeConfig();
        return DataConsistencyCalculateAlgorithmFactory.getAllInstances().stream().map(each -> new DataConsistencyCheckAlgorithmInfo(each.getType(), each.getSupportedDatabaseTypes(), each.getDescription())).collect(Collectors.toList());
    }

    @Override
    public DataConsistencyCalculateAlgorithm buildDataConsistencyCalculateAlgorithm(PipelineJobConfiguration jobConfig, String algorithmType, Properties algorithmProps) {
        ShardingSpherePreconditions.checkState((null != algorithmType || null != jobConfig ? 1 : 0) != 0, () -> new IllegalArgumentException("Algorithm type and job configuration are null."));
        return null == algorithmType ? DataConsistencyCalculateAlgorithmChooser.choose(DatabaseTypeFactory.getInstance((String)jobConfig.getSourceDatabaseType()), DatabaseTypeFactory.getInstance((String)this.getTargetDatabaseType(jobConfig))) : DataConsistencyCalculateAlgorithmFactory.newInstance((String)algorithmType, (Properties)algorithmProps);
    }

    @Override
    public Map<String, DataConsistencyCheckResult> dataConsistencyCheck(PipelineJobConfiguration jobConfig, DataConsistencyCalculateAlgorithm calculateAlgorithm, ConsistencyCheckJobItemContext checkJobItemContext) {
        String jobId = jobConfig.getJobId();
        PipelineDataConsistencyChecker dataConsistencyChecker = this.buildPipelineDataConsistencyChecker(jobConfig, this.buildPipelineProcessContext(jobConfig), checkJobItemContext);
        Map result = dataConsistencyChecker.check(calculateAlgorithm);
        log.info("job {} with check algorithm '{}' data consistency checker result {}", new Object[]{jobId, calculateAlgorithm.getType(), result});
        return result;
    }

    protected abstract PipelineDataConsistencyChecker buildPipelineDataConsistencyChecker(PipelineJobConfiguration var1, InventoryIncrementalProcessContext var2, ConsistencyCheckJobItemContext var3);

    @Override
    public boolean aggregateDataConsistencyCheckResults(String jobId, Map<String, DataConsistencyCheckResult> checkResults) {
        if (checkResults.isEmpty()) {
            log.info("aggregateDataConsistencyCheckResults, checkResults empty, jobId={}", (Object)jobId);
            return false;
        }
        for (Map.Entry<String, DataConsistencyCheckResult> entry : checkResults.entrySet()) {
            DataConsistencyCheckResult checkResult = entry.getValue();
            if (checkResult.isMatched()) continue;
            return false;
        }
        return true;
    }
}

