/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.data.pipeline.core.api.impl;

import com.google.common.base.Strings;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.shardingsphere.data.pipeline.api.check.consistency.DataConsistencyCheckResult;
import org.apache.shardingsphere.data.pipeline.api.job.JobType;
import org.apache.shardingsphere.data.pipeline.core.api.GovernanceRepositoryAPI;
import org.apache.shardingsphere.data.pipeline.core.metadata.node.PipelineMetaDataNode;
import org.apache.shardingsphere.data.pipeline.yaml.consistency.YamlDataConsistencyCheckResult;
import org.apache.shardingsphere.data.pipeline.yaml.consistency.YamlDataConsistencyCheckResultSwapper;
import org.apache.shardingsphere.infra.util.yaml.YamlEngine;
import org.apache.shardingsphere.mode.repository.cluster.ClusterPersistRepository;
import org.apache.shardingsphere.mode.repository.cluster.listener.DataChangedEventListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class GovernanceRepositoryAPIImpl
implements GovernanceRepositoryAPI {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(GovernanceRepositoryAPIImpl.class);
    private final ClusterPersistRepository repository;

    @Override
    public boolean isExisted(String key) {
        return null != this.repository.getDirectly(key);
    }

    @Override
    public void persistJobItemProgress(String jobId, int shardingItem, String progressValue) {
        this.repository.persist(PipelineMetaDataNode.getJobOffsetItemPath(jobId, shardingItem), progressValue);
    }

    @Override
    public String getJobItemProgress(String jobId, int shardingItem) {
        return this.repository.getDirectly(PipelineMetaDataNode.getJobOffsetItemPath(jobId, shardingItem));
    }

    @Override
    public Optional<String> getCheckLatestJobId(String jobId) {
        return Optional.ofNullable(this.repository.getDirectly(PipelineMetaDataNode.getCheckLatestJobIdPath(jobId)));
    }

    @Override
    public void persistCheckLatestJobId(String jobId, String checkJobId) {
        log.info("persist check job id '{}' for job {}", (Object)checkJobId, (Object)jobId);
        this.repository.persist(PipelineMetaDataNode.getCheckLatestJobIdPath(jobId), String.valueOf(checkJobId));
    }

    @Override
    public Map<String, DataConsistencyCheckResult> getCheckJobResult(String parentJobId, String checkJobId) {
        HashMap<String, DataConsistencyCheckResult> result = new HashMap<String, DataConsistencyCheckResult>();
        String yamlCheckResultMapText = this.repository.getDirectly(PipelineMetaDataNode.getCheckJobResultPath(parentJobId, checkJobId));
        if (Strings.isNullOrEmpty((String)yamlCheckResultMapText)) {
            return Collections.emptyMap();
        }
        YamlDataConsistencyCheckResultSwapper swapper = new YamlDataConsistencyCheckResultSwapper();
        Map yamlCheckResultMap = (Map)YamlEngine.unmarshal((String)yamlCheckResultMapText, Map.class, (boolean)true);
        for (Map.Entry entry : yamlCheckResultMap.entrySet()) {
            result.put((String)entry.getKey(), swapper.swapToObject((String)entry.getValue()));
        }
        return result;
    }

    @Override
    public void persistCheckJobResult(String jobId, String checkJobId, Map<String, DataConsistencyCheckResult> checkResultMap) {
        if (null == checkResultMap) {
            log.warn("checkResultMap is null, jobId {}, checkJobId {}", (Object)jobId, (Object)checkJobId);
            return;
        }
        log.info("persist check job result for job {}", (Object)checkJobId);
        LinkedHashMap<String, String> yamlCheckResultMap = new LinkedHashMap<String, String>();
        for (Map.Entry<String, DataConsistencyCheckResult> entry : checkResultMap.entrySet()) {
            YamlDataConsistencyCheckResult yamlCheckResult = new YamlDataConsistencyCheckResultSwapper().swapToYamlConfiguration(entry.getValue());
            yamlCheckResultMap.put(entry.getKey(), YamlEngine.marshal((Object)yamlCheckResult));
        }
        this.repository.persist(PipelineMetaDataNode.getCheckJobResultPath(jobId, checkJobId), YamlEngine.marshal(yamlCheckResultMap));
    }

    @Override
    public void deleteCheckJobResult(String jobId, String checkJobId) {
        log.info("deleteCheckJobResult, jobId={}, checkJobId={}", (Object)jobId, (Object)checkJobId);
        this.repository.delete(PipelineMetaDataNode.getCheckJobResultPath(jobId, checkJobId));
    }

    @Override
    public Collection<String> listCheckJobIds(String jobId) {
        return this.repository.getChildrenKeys(PipelineMetaDataNode.getCheckJobIdsRootPath(jobId));
    }

    @Override
    public void deleteJob(String jobId) {
        log.info("delete job {}", (Object)jobId);
        this.repository.delete(PipelineMetaDataNode.getJobRootPath(jobId));
    }

    @Override
    public List<String> getChildrenKeys(String key) {
        return this.repository.getChildrenKeys(key);
    }

    @Override
    public void watch(String key, DataChangedEventListener listener) {
        this.repository.watch(key, listener, null);
    }

    @Override
    public void persist(String key, String value) {
        this.repository.persist(key, value);
    }

    @Override
    public List<Integer> getShardingItems(String jobId) {
        List<String> result = this.getChildrenKeys(PipelineMetaDataNode.getJobOffsetPath(jobId));
        log.info("getShardingItems, jobId={}, offsetKeys={}", (Object)jobId, result);
        return result.stream().map(Integer::parseInt).collect(Collectors.toList());
    }

    @Override
    public String getMetaDataDataSources(JobType jobType) {
        return this.repository.getDirectly(PipelineMetaDataNode.getMetaDataDataSourcesPath(jobType));
    }

    @Override
    public void persistMetaDataDataSources(JobType jobType, String metaDataDataSources) {
        this.repository.persist(PipelineMetaDataNode.getMetaDataDataSourcesPath(jobType), metaDataDataSources);
    }

    @Override
    public String getMetaDataProcessConfiguration(JobType jobType) {
        return this.repository.getDirectly(PipelineMetaDataNode.getMetaDataProcessConfigPath(jobType));
    }

    @Override
    public void persistMetaDataProcessConfiguration(JobType jobType, String processConfigYamlText) {
        this.repository.persist(PipelineMetaDataNode.getMetaDataProcessConfigPath(jobType), processConfigYamlText);
    }

    @Override
    public String getJobItemErrorMessage(String jobId, int shardingItem) {
        return this.repository.getDirectly(PipelineMetaDataNode.getJobItemErrorMessagePath(jobId, shardingItem));
    }

    @Override
    public void cleanJobItemErrorMessage(String jobId, int shardingItem) {
        this.repository.delete(PipelineMetaDataNode.getJobItemErrorMessagePath(jobId, shardingItem));
    }

    @Generated
    public GovernanceRepositoryAPIImpl(ClusterPersistRepository repository) {
        this.repository = repository;
    }
}

