/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.data.pipeline.core.api.impl;

import com.google.common.base.Strings;
import java.util.Collection;
import java.util.HashMap;
import lombok.Generated;
import org.apache.shardingsphere.data.pipeline.api.context.PipelineJobItemContext;
import org.apache.shardingsphere.data.pipeline.api.job.JobStatus;
import org.apache.shardingsphere.data.pipeline.api.job.progress.InventoryIncrementalJobItemProgress;
import org.apache.shardingsphere.data.pipeline.api.job.progress.JobItemIncrementalTasksProgress;
import org.apache.shardingsphere.data.pipeline.api.job.progress.JobItemInventoryTasksProgress;
import org.apache.shardingsphere.data.pipeline.api.task.progress.InventoryTaskProgress;
import org.apache.shardingsphere.data.pipeline.core.api.PipelineAPIFactory;
import org.apache.shardingsphere.data.pipeline.core.api.PipelineJobItemAPI;
import org.apache.shardingsphere.data.pipeline.core.context.InventoryIncrementalJobItemContext;
import org.apache.shardingsphere.data.pipeline.core.job.progress.yaml.YamlInventoryIncrementalJobItemProgress;
import org.apache.shardingsphere.data.pipeline.core.job.progress.yaml.YamlInventoryIncrementalJobItemProgressSwapper;
import org.apache.shardingsphere.data.pipeline.core.task.IncrementalTask;
import org.apache.shardingsphere.data.pipeline.core.task.InventoryTask;
import org.apache.shardingsphere.infra.util.yaml.YamlEngine;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class InventoryIncrementalJobItemAPIImpl
implements PipelineJobItemAPI {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(InventoryIncrementalJobItemAPIImpl.class);
    private static final YamlInventoryIncrementalJobItemProgressSwapper SWAPPER = new YamlInventoryIncrementalJobItemProgressSwapper();

    @Override
    public void persistJobItemProgress(PipelineJobItemContext jobItemContext) {
        InventoryIncrementalJobItemContext context = (InventoryIncrementalJobItemContext)jobItemContext;
        InventoryIncrementalJobItemProgress jobItemProgress = new InventoryIncrementalJobItemProgress();
        jobItemProgress.setStatus(jobItemContext.getStatus());
        jobItemProgress.setSourceDatabaseType(jobItemContext.getJobConfig().getSourceDatabaseType());
        jobItemProgress.setDataSourceName(jobItemContext.getDataSourceName());
        jobItemProgress.setIncremental(this.getIncrementalTasksProgress(context.getIncrementalTasks()));
        jobItemProgress.setInventory(this.getInventoryTasksProgress(context.getInventoryTasks()));
        jobItemProgress.setProcessedRecordsCount(context.getProcessedRecordsCount());
        String value = YamlEngine.marshal((Object)SWAPPER.swapToYamlConfiguration(jobItemProgress));
        PipelineAPIFactory.getGovernanceRepositoryAPI().persistJobItemProgress(jobItemContext.getJobId(), jobItemContext.getShardingItem(), value);
    }

    private JobItemIncrementalTasksProgress getIncrementalTasksProgress(Collection<IncrementalTask> incrementalTasks) {
        IncrementalTask incrementalTask = incrementalTasks.size() > 0 ? incrementalTasks.iterator().next() : null;
        return new JobItemIncrementalTasksProgress(null != incrementalTask ? incrementalTask.getTaskProgress() : null);
    }

    private JobItemInventoryTasksProgress getInventoryTasksProgress(Collection<InventoryTask> inventoryTasks) {
        HashMap<String, InventoryTaskProgress> inventoryTaskProgressMap = new HashMap<String, InventoryTaskProgress>();
        for (InventoryTask each : inventoryTasks) {
            inventoryTaskProgressMap.put(each.getTaskId(), each.getTaskProgress());
        }
        return new JobItemInventoryTasksProgress(inventoryTaskProgressMap);
    }

    public InventoryIncrementalJobItemProgress getJobItemProgress(String jobId, int shardingItem) {
        String data = PipelineAPIFactory.getGovernanceRepositoryAPI().getJobItemProgress(jobId, shardingItem);
        return Strings.isNullOrEmpty((String)data) ? null : SWAPPER.swapToObject((YamlInventoryIncrementalJobItemProgress)YamlEngine.unmarshal((String)data, YamlInventoryIncrementalJobItemProgress.class));
    }

    @Override
    public void updateJobItemStatus(String jobId, int shardingItem, JobStatus status) {
        InventoryIncrementalJobItemProgress jobItemProgress = this.getJobItemProgress(jobId, shardingItem);
        if (null == jobItemProgress) {
            log.warn("updateJobItemStatus, jobItemProgress is null, jobId={}, shardingItem={}", (Object)jobId, (Object)shardingItem);
            return;
        }
        jobItemProgress.setStatus(status);
        PipelineAPIFactory.getGovernanceRepositoryAPI().persistJobItemProgress(jobId, shardingItem, YamlEngine.marshal((Object)SWAPPER.swapToYamlConfiguration(jobItemProgress)));
    }
}

