/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.data.pipeline.core.api.impl;

import com.google.common.base.Strings;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.shardingsphere.data.pipeline.api.job.JobType;
import org.apache.shardingsphere.data.pipeline.core.api.PipelineAPIFactory;
import org.apache.shardingsphere.data.pipeline.core.api.PipelineMetaDataPersistService;
import org.apache.shardingsphere.infra.datasource.props.DataSourceProperties;
import org.apache.shardingsphere.infra.util.yaml.YamlEngine;
import org.apache.shardingsphere.infra.yaml.config.swapper.resource.YamlDataSourceConfigurationSwapper;

public final class PipelineDataSourcePersistService
implements PipelineMetaDataPersistService<Map<String, DataSourceProperties>> {
    private final YamlDataSourceConfigurationSwapper swapper = new YamlDataSourceConfigurationSwapper();

    @Override
    public Map<String, DataSourceProperties> load(JobType jobType) {
        String dataSourcesProperties = PipelineAPIFactory.getGovernanceRepositoryAPI().getMetaDataDataSources(jobType);
        if (Strings.isNullOrEmpty((String)dataSourcesProperties)) {
            return Collections.emptyMap();
        }
        Map yamlDataSources = (Map)YamlEngine.unmarshal((String)dataSourcesProperties, Map.class);
        LinkedHashMap<String, DataSourceProperties> result = new LinkedHashMap<String, DataSourceProperties>(yamlDataSources.size());
        yamlDataSources.forEach((key, value) -> result.put((String)key, this.swapper.swapToDataSourceProperties(value)));
        return result;
    }

    @Override
    public void persist(JobType jobType, Map<String, DataSourceProperties> dataSourcePropsMap) {
        LinkedHashMap<String, Map> dataSourceMap = new LinkedHashMap<String, Map>(dataSourcePropsMap.size());
        for (Map.Entry<String, DataSourceProperties> entry : dataSourcePropsMap.entrySet()) {
            dataSourceMap.put(entry.getKey(), this.swapper.swapToMap(entry.getValue()));
        }
        PipelineAPIFactory.getGovernanceRepositoryAPI().persistMetaDataDataSources(jobType, YamlEngine.marshal(dataSourceMap));
    }
}

