/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.data.pipeline.core.api.impl;

import com.google.common.base.Strings;
import org.apache.shardingsphere.data.pipeline.api.config.process.PipelineProcessConfiguration;
import org.apache.shardingsphere.data.pipeline.api.job.JobType;
import org.apache.shardingsphere.data.pipeline.core.api.PipelineAPIFactory;
import org.apache.shardingsphere.data.pipeline.core.api.PipelineMetaDataPersistService;
import org.apache.shardingsphere.data.pipeline.yaml.process.YamlPipelineProcessConfiguration;
import org.apache.shardingsphere.data.pipeline.yaml.process.YamlPipelineProcessConfigurationSwapper;
import org.apache.shardingsphere.infra.util.yaml.YamlEngine;

public final class PipelineProcessConfigurationPersistService
implements PipelineMetaDataPersistService<PipelineProcessConfiguration> {
    private final YamlPipelineProcessConfigurationSwapper swapper = new YamlPipelineProcessConfigurationSwapper();

    @Override
    public PipelineProcessConfiguration load(JobType jobType) {
        String yamlText = PipelineAPIFactory.getGovernanceRepositoryAPI().getMetaDataProcessConfiguration(jobType);
        if (Strings.isNullOrEmpty((String)yamlText)) {
            return null;
        }
        YamlPipelineProcessConfiguration yamlConfig = (YamlPipelineProcessConfiguration)YamlEngine.unmarshal((String)yamlText, YamlPipelineProcessConfiguration.class, (boolean)true);
        return null == yamlConfig || yamlConfig.isAllFieldsNull() ? null : this.swapper.swapToObject(yamlConfig);
    }

    @Override
    public void persist(JobType jobType, PipelineProcessConfiguration processConfig) {
        String yamlText = YamlEngine.marshal((Object)this.swapper.swapToYamlConfiguration(processConfig));
        PipelineAPIFactory.getGovernanceRepositoryAPI().persistMetaDataProcessConfiguration(jobType, yamlText);
    }
}

