/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.data.pipeline.core.check.consistency.algorithm;

import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.Statement;
import lombok.Generated;
import org.apache.shardingsphere.data.pipeline.spi.check.consistency.DataConsistencyCalculateAlgorithm;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractDataConsistencyCalculateAlgorithm
implements DataConsistencyCalculateAlgorithm {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AbstractDataConsistencyCalculateAlgorithm.class);
    private volatile boolean canceling;
    private volatile Statement currentStatement;

    protected <T extends Statement> T setCurrentStatement(T statement) {
        this.currentStatement = statement;
        return statement;
    }

    public void cancel() throws SQLException {
        this.canceling = true;
        Statement statement = this.currentStatement;
        if (null == statement || statement.isClosed()) {
            log.info("cancel, statement is null or closed");
            return;
        }
        long startTimeMillis = System.currentTimeMillis();
        try {
            statement.cancel();
        }
        catch (SQLFeatureNotSupportedException ex) {
            log.info("cancel is not supported: {}", (Object)ex.getMessage());
        }
        catch (SQLException ex) {
            log.info("cancel failed: {}", (Object)ex.getMessage());
        }
        catch (RuntimeException ex) {
            log.info("cancel failed: {}", (Object)ex.getMessage());
        }
        log.info("cancel cost {} ms", (Object)(System.currentTimeMillis() - startTimeMillis));
    }

    @Generated
    public boolean isCanceling() {
        return this.canceling;
    }
}

