/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.data.pipeline.core.check.consistency.algorithm;

import java.util.Iterator;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import lombok.Generated;
import org.apache.shardingsphere.data.pipeline.api.check.consistency.DataConsistencyCalculateParameter;
import org.apache.shardingsphere.data.pipeline.api.check.consistency.DataConsistencyCalculatedResult;
import org.apache.shardingsphere.data.pipeline.core.check.consistency.algorithm.AbstractDataConsistencyCalculateAlgorithm;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractStreamingDataConsistencyCalculateAlgorithm
extends AbstractDataConsistencyCalculateAlgorithm {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AbstractStreamingDataConsistencyCalculateAlgorithm.class);

    public final Iterable<DataConsistencyCalculatedResult> calculate(DataConsistencyCalculateParameter parameter) {
        return new ResultIterable(parameter);
    }

    protected abstract Optional<DataConsistencyCalculatedResult> calculateChunk(DataConsistencyCalculateParameter var1);

    @Generated
    public AbstractStreamingDataConsistencyCalculateAlgorithm() {
    }

    final class ResultIterator
    implements Iterator<DataConsistencyCalculatedResult> {
        private final DataConsistencyCalculateParameter parameter;
        private final AtomicInteger calculationCount = new AtomicInteger(0);
        private volatile Optional<DataConsistencyCalculatedResult> nextResult;

        @Override
        public boolean hasNext() {
            this.calculateIfNecessary();
            return this.nextResult.isPresent();
        }

        @Override
        public DataConsistencyCalculatedResult next() {
            this.calculateIfNecessary();
            Optional<DataConsistencyCalculatedResult> nextResult = this.nextResult;
            this.parameter.setPreviousCalculatedResult(nextResult.orElse(null));
            this.nextResult = null;
            return nextResult.orElse(null);
        }

        private void calculateIfNecessary() {
            if (null != this.nextResult) {
                return;
            }
            this.nextResult = AbstractStreamingDataConsistencyCalculateAlgorithm.this.calculateChunk(this.parameter);
            if (!this.nextResult.isPresent()) {
                log.info("nextResult not present, calculation done. calculationCount={}", (Object)this.calculationCount);
            }
            if (0 == this.calculationCount.incrementAndGet() % 1000000) {
                log.warn("possible infinite loop, calculationCount={}", (Object)this.calculationCount);
            }
        }

        @Generated
        public ResultIterator(DataConsistencyCalculateParameter parameter) {
            this.parameter = parameter;
        }
    }

    final class ResultIterable
    implements Iterable<DataConsistencyCalculatedResult> {
        private final DataConsistencyCalculateParameter parameter;

        @Override
        public Iterator<DataConsistencyCalculatedResult> iterator() {
            return new ResultIterator(this.parameter);
        }

        @Generated
        public ResultIterable(DataConsistencyCalculateParameter parameter) {
            this.parameter = parameter;
        }
    }
}

