/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.data.pipeline.core.check.consistency.algorithm;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Properties;
import java.util.stream.Collectors;
import javax.sql.DataSource;
import lombok.Generated;
import org.apache.shardingsphere.data.pipeline.api.check.consistency.DataConsistencyCalculateParameter;
import org.apache.shardingsphere.data.pipeline.api.check.consistency.DataConsistencyCalculatedResult;
import org.apache.shardingsphere.data.pipeline.core.check.consistency.algorithm.AbstractDataConsistencyCalculateAlgorithm;
import org.apache.shardingsphere.data.pipeline.core.exception.data.UnsupportedCRC32DataConsistencyCalculateAlgorithmException;
import org.apache.shardingsphere.data.pipeline.core.sqlbuilder.PipelineSQLBuilderFactory;
import org.apache.shardingsphere.data.pipeline.spi.sqlbuilder.PipelineSQLBuilder;
import org.apache.shardingsphere.infra.database.type.dialect.MySQLDatabaseType;
import org.apache.shardingsphere.infra.util.exception.ShardingSpherePreconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class CRC32MatchDataConsistencyCalculateAlgorithm
extends AbstractDataConsistencyCalculateAlgorithm {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(CRC32MatchDataConsistencyCalculateAlgorithm.class);
    private static final Collection<String> SUPPORTED_DATABASE_TYPES = Collections.singletonList(new MySQLDatabaseType().getType());
    private Properties props;

    public void init(Properties props) {
        this.props = props;
    }

    public Iterable<DataConsistencyCalculatedResult> calculate(DataConsistencyCalculateParameter parameter) {
        PipelineSQLBuilder sqlBuilder = PipelineSQLBuilderFactory.getInstance(parameter.getDatabaseType());
        List calculatedItems = parameter.getColumnNames().stream().map(each -> this.calculateCRC32(sqlBuilder, parameter, (String)each)).collect(Collectors.toList());
        return Collections.singletonList(new CalculatedResult(((CalculatedItem)calculatedItems.get(0)).getRecordsCount(), calculatedItems.stream().map(CalculatedItem::getCrc32).collect(Collectors.toList())));
    }

    private CalculatedItem calculateCRC32(PipelineSQLBuilder sqlBuilder, DataConsistencyCalculateParameter parameter, String columnName) {
        String logicTableName = parameter.getLogicTableName();
        String schemaName = parameter.getSchemaName();
        Optional sql = sqlBuilder.buildCRC32SQL(schemaName, logicTableName, columnName);
        ShardingSpherePreconditions.checkState((boolean)sql.isPresent(), () -> new UnsupportedCRC32DataConsistencyCalculateAlgorithmException(parameter.getDatabaseType()));
        return this.calculateCRC32((DataSource)parameter.getDataSource(), logicTableName, (String)sql.get());
    }

    /*
     * Exception decompiling
     */
    private CalculatedItem calculateCRC32(DataSource dataSource, String logicTableName, String sql) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 5 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public String getType() {
        return "CRC32_MATCH";
    }

    public Collection<String> getSupportedDatabaseTypes() {
        return SUPPORTED_DATABASE_TYPES;
    }

    public String getDescription() {
        return "Match CRC32 of records.";
    }

    @Generated
    public Properties getProps() {
        return this.props;
    }

    private static final class CalculatedResult
    implements DataConsistencyCalculatedResult {
        private final int recordsCount;
        private final Collection<Long> columnsCrc32;

        public boolean equals(Object o) {
            if (null == o) {
                return false;
            }
            if (this == o) {
                return true;
            }
            if (this.getClass() != o.getClass()) {
                log.warn("CalculatedResult type not match, o.className={}", (Object)o.getClass().getName());
                return false;
            }
            CalculatedResult that = (CalculatedResult)o;
            if (this.recordsCount != that.recordsCount) {
                log.info("recordsCount not match, recordsCount={}, that.recordsCount={}", (Object)this.recordsCount, (Object)that.recordsCount);
                return false;
            }
            if (!this.columnsCrc32.equals(that.columnsCrc32)) {
                log.info("columnsCrc32 not match, columnsCrc32={}, that.columnsCrc32={}", this.columnsCrc32, that.columnsCrc32);
                return false;
            }
            return true;
        }

        public int hashCode() {
            int result = this.recordsCount;
            result = 31 * result + this.columnsCrc32.hashCode();
            return result;
        }

        @Generated
        public CalculatedResult(int recordsCount, Collection<Long> columnsCrc32) {
            this.recordsCount = recordsCount;
            this.columnsCrc32 = columnsCrc32;
        }

        @Generated
        public int getRecordsCount() {
            return this.recordsCount;
        }

        @Generated
        public Collection<Long> getColumnsCrc32() {
            return this.columnsCrc32;
        }
    }

    private static final class CalculatedItem {
        private final long crc32;
        private final int recordsCount;

        @Generated
        public CalculatedItem(long crc32, int recordsCount) {
            this.crc32 = crc32;
            this.recordsCount = recordsCount;
        }

        @Generated
        public long getCrc32() {
            return this.crc32;
        }

        @Generated
        public int getRecordsCount() {
            return this.recordsCount;
        }
    }
}

