/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.data.pipeline.core.check.datasource;

import java.sql.SQLException;
import java.util.Collection;
import javax.sql.DataSource;
import lombok.Generated;
import org.apache.shardingsphere.data.pipeline.api.config.TableNameSchemaNameMapping;
import org.apache.shardingsphere.data.pipeline.core.exception.job.PrepareJobWithInvalidConnectionException;
import org.apache.shardingsphere.data.pipeline.core.exception.job.PrepareJobWithTargetTableNotEmptyException;
import org.apache.shardingsphere.data.pipeline.core.sqlbuilder.PipelineSQLBuilderFactory;
import org.apache.shardingsphere.data.pipeline.spi.check.datasource.DataSourceChecker;
import org.apache.shardingsphere.data.pipeline.spi.sqlbuilder.PipelineSQLBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractDataSourceChecker
implements DataSourceChecker {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AbstractDataSourceChecker.class);

    public final void checkConnection(Collection<? extends DataSource> dataSources) {
        try {
            for (DataSource dataSource : dataSources) {
                dataSource.getConnection().close();
            }
        }
        catch (SQLException ex) {
            throw new PrepareJobWithInvalidConnectionException(ex);
        }
    }

    public final void checkTargetTable(Collection<? extends DataSource> dataSources, TableNameSchemaNameMapping tableNameSchemaNameMapping, Collection<String> logicTableNames) {
        try {
            for (DataSource dataSource : dataSources) {
                for (String tableName : logicTableNames) {
                    if (this.checkEmpty(dataSource, tableNameSchemaNameMapping.getSchemaName(tableName), tableName)) continue;
                    throw new PrepareJobWithTargetTableNotEmptyException(tableName);
                }
            }
        }
        catch (SQLException ex) {
            throw new PrepareJobWithInvalidConnectionException(ex);
        }
    }

    /*
     * Exception decompiling
     */
    private boolean checkEmpty(DataSource dataSource, String schemaName, String tableName) throws SQLException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 4 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private PipelineSQLBuilder getSQLBuilder() {
        return PipelineSQLBuilderFactory.getInstance(this.getDatabaseType());
    }

    protected abstract String getDatabaseType();

    public String getType() {
        return this.getDatabaseType();
    }
}

