/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.data.pipeline.core.config.process;

import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import java.util.List;
import java.util.Properties;
import java.util.regex.Pattern;
import org.apache.shardingsphere.data.pipeline.api.config.process.PipelineProcessConfiguration;
import org.apache.shardingsphere.data.pipeline.yaml.process.YamlPipelineProcessConfiguration;
import org.apache.shardingsphere.data.pipeline.yaml.process.YamlPipelineProcessConfigurationSwapper;
import org.apache.shardingsphere.data.pipeline.yaml.process.YamlPipelineReadConfiguration;
import org.apache.shardingsphere.data.pipeline.yaml.process.YamlPipelineWriteConfiguration;
import org.apache.shardingsphere.infra.yaml.config.pojo.algorithm.YamlAlgorithmConfiguration;

public final class PipelineProcessConfigurationUtil {
    private static final YamlPipelineProcessConfigurationSwapper SWAPPER = new YamlPipelineProcessConfigurationSwapper();
    private static final String CONF_PATH_REGEX = "^/|(/[a-zA-Z_]+)+$";
    private static final Pattern CONF_PATH_PATTERN = Pattern.compile("^/|(/[a-zA-Z_]+)+$");

    public static PipelineProcessConfiguration convertWithDefaultValue(PipelineProcessConfiguration originalConfig) {
        YamlPipelineProcessConfiguration yamlConfig = null != originalConfig ? SWAPPER.swapToYamlConfiguration(originalConfig) : new YamlPipelineProcessConfiguration();
        PipelineProcessConfigurationUtil.fillInDefaultValue(yamlConfig);
        return SWAPPER.swapToObject(yamlConfig);
    }

    public static void fillInDefaultValue(YamlPipelineProcessConfiguration yamlConfig) {
        if (null == yamlConfig.getRead()) {
            yamlConfig.setRead(YamlPipelineReadConfiguration.buildWithDefaultValue());
        } else {
            yamlConfig.getRead().fillInNullFieldsWithDefaultValue();
        }
        if (null == yamlConfig.getWrite()) {
            yamlConfig.setWrite(YamlPipelineWriteConfiguration.buildWithDefaultValue());
        } else {
            yamlConfig.getWrite().fillInNullFieldsWithDefaultValue();
        }
        if (null == yamlConfig.getStreamChannel()) {
            Properties props = new Properties();
            props.put("block-queue-size", (Object)10000);
            yamlConfig.setStreamChannel(new YamlAlgorithmConfiguration("MEMORY", props));
        }
    }

    public static void verifyConfPath(String confPath) {
        Preconditions.checkArgument((boolean)CONF_PATH_PATTERN.matcher(confPath).matches(), (String)"Invalid confPath, it doesn't match pattern: %s", (Object)CONF_PATH_REGEX);
    }

    public static void setFieldsNullByConfPath(YamlPipelineProcessConfiguration targetYamlProcessConfig, String confPath) {
        List confPathNodes = Splitter.on((char)'/').splitToList((CharSequence)confPath);
        if (2 == confPathNodes.size()) {
            String levelOne = ((String)confPathNodes.get(1)).toUpperCase();
            if (levelOne.isEmpty()) {
                targetYamlProcessConfig.setAllFieldsNull();
            } else {
                targetYamlProcessConfig.setFieldNull(levelOne);
            }
        } else if (3 == confPathNodes.size()) {
            String levelOne = ((String)confPathNodes.get(1)).toUpperCase();
            String levelTwo = ((String)confPathNodes.get(2)).toUpperCase();
            if ("READ".equals(levelOne) && null != targetYamlProcessConfig.getRead()) {
                targetYamlProcessConfig.getRead().setFieldNull(levelTwo);
            } else if ("WRITE".equals(levelOne) && null != targetYamlProcessConfig.getWrite()) {
                targetYamlProcessConfig.getWrite().setFieldNull(levelTwo);
            }
        }
    }
}

