/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.data.pipeline.core.context;

import lombok.Generated;
import org.apache.commons.lang3.concurrent.LazyInitializer;
import org.apache.shardingsphere.data.pipeline.api.config.process.PipelineProcessConfiguration;
import org.apache.shardingsphere.data.pipeline.api.config.process.PipelineReadConfiguration;
import org.apache.shardingsphere.data.pipeline.api.config.process.PipelineWriteConfiguration;
import org.apache.shardingsphere.data.pipeline.core.config.process.PipelineProcessConfigurationUtil;
import org.apache.shardingsphere.data.pipeline.core.context.InventoryIncrementalProcessContext;
import org.apache.shardingsphere.data.pipeline.core.execute.ExecuteEngine;
import org.apache.shardingsphere.data.pipeline.spi.ingest.channel.PipelineChannelCreator;
import org.apache.shardingsphere.data.pipeline.spi.ingest.channel.PipelineChannelCreatorFactory;
import org.apache.shardingsphere.data.pipeline.spi.ratelimit.JobRateLimitAlgorithm;
import org.apache.shardingsphere.data.pipeline.spi.ratelimit.JobRateLimitAlgorithmFactory;
import org.apache.shardingsphere.infra.config.algorithm.AlgorithmConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractInventoryIncrementalProcessContext
implements InventoryIncrementalProcessContext {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AbstractInventoryIncrementalProcessContext.class);
    private final PipelineProcessConfiguration pipelineProcessConfig;
    private final JobRateLimitAlgorithm readRateLimitAlgorithm;
    private final JobRateLimitAlgorithm writeRateLimitAlgorithm;
    private final PipelineChannelCreator pipelineChannelCreator;
    private final LazyInitializer<ExecuteEngine> inventoryDumperExecuteEngineLazyInitializer;
    private final LazyInitializer<ExecuteEngine> inventoryImporterExecuteEngineLazyInitializer;
    private final LazyInitializer<ExecuteEngine> incrementalExecuteEngineLazyInitializer;

    public AbstractInventoryIncrementalProcessContext(final String jobId, PipelineProcessConfiguration originalProcessConfig) {
        PipelineProcessConfiguration processConfig;
        this.pipelineProcessConfig = processConfig = PipelineProcessConfigurationUtil.convertWithDefaultValue(originalProcessConfig);
        final PipelineReadConfiguration readConfig = processConfig.getRead();
        AlgorithmConfiguration readRateLimiter = readConfig.getRateLimiter();
        this.readRateLimitAlgorithm = null != readRateLimiter ? JobRateLimitAlgorithmFactory.newInstance((AlgorithmConfiguration)readRateLimiter) : null;
        final PipelineWriteConfiguration writeConfig = processConfig.getWrite();
        AlgorithmConfiguration writeRateLimiter = writeConfig.getRateLimiter();
        this.writeRateLimitAlgorithm = null != writeRateLimiter ? JobRateLimitAlgorithmFactory.newInstance((AlgorithmConfiguration)writeRateLimiter) : null;
        AlgorithmConfiguration streamChannel = processConfig.getStreamChannel();
        this.pipelineChannelCreator = PipelineChannelCreatorFactory.newInstance((AlgorithmConfiguration)streamChannel);
        this.inventoryDumperExecuteEngineLazyInitializer = new LazyInitializer<ExecuteEngine>(){

            protected ExecuteEngine initialize() {
                return ExecuteEngine.newFixedThreadInstance(readConfig.getWorkerThread(), "Inventory-" + jobId);
            }
        };
        this.inventoryImporterExecuteEngineLazyInitializer = new LazyInitializer<ExecuteEngine>(){

            protected ExecuteEngine initialize() {
                return ExecuteEngine.newFixedThreadInstance(writeConfig.getWorkerThread(), "Importer-" + jobId);
            }
        };
        this.incrementalExecuteEngineLazyInitializer = new LazyInitializer<ExecuteEngine>(){

            protected ExecuteEngine initialize() {
                return ExecuteEngine.newCachedThreadInstance("Incremental-" + jobId);
            }
        };
    }

    @Override
    public ExecuteEngine getInventoryDumperExecuteEngine() {
        return (ExecuteEngine)this.inventoryDumperExecuteEngineLazyInitializer.get();
    }

    @Override
    public ExecuteEngine getInventoryImporterExecuteEngine() {
        return (ExecuteEngine)this.inventoryImporterExecuteEngineLazyInitializer.get();
    }

    public ExecuteEngine getIncrementalExecuteEngine() {
        return (ExecuteEngine)this.incrementalExecuteEngineLazyInitializer.get();
    }

    @Generated
    public PipelineProcessConfiguration getPipelineProcessConfig() {
        return this.pipelineProcessConfig;
    }

    @Override
    @Generated
    public JobRateLimitAlgorithm getReadRateLimitAlgorithm() {
        return this.readRateLimitAlgorithm;
    }

    @Override
    @Generated
    public JobRateLimitAlgorithm getWriteRateLimitAlgorithm() {
        return this.writeRateLimitAlgorithm;
    }

    @Override
    @Generated
    public PipelineChannelCreator getPipelineChannelCreator() {
        return this.pipelineChannelCreator;
    }

    @Generated
    public LazyInitializer<ExecuteEngine> getInventoryDumperExecuteEngineLazyInitializer() {
        return this.inventoryDumperExecuteEngineLazyInitializer;
    }

    @Generated
    public LazyInitializer<ExecuteEngine> getInventoryImporterExecuteEngineLazyInitializer() {
        return this.inventoryImporterExecuteEngineLazyInitializer;
    }

    @Generated
    public LazyInitializer<ExecuteEngine> getIncrementalExecuteEngineLazyInitializer() {
        return this.incrementalExecuteEngineLazyInitializer;
    }
}

