/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.data.pipeline.core.context;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.apache.shardingsphere.infra.config.mode.ModeConfiguration;
import org.apache.shardingsphere.mode.manager.ContextManager;

public final class PipelineContext {
    private static volatile ModeConfiguration modeConfig;
    private static volatile ContextManager contextManager;
    private static final ExecutorService EVENT_LISTENER_EXECUTOR;

    public static ModeConfiguration getModeConfig() {
        return modeConfig;
    }

    public static void initModeConfig(ModeConfiguration modeConfig) {
        PipelineContext.modeConfig = modeConfig;
    }

    public static ContextManager getContextManager() {
        return contextManager;
    }

    public static void initContextManager(ContextManager contextManager) {
        PipelineContext.contextManager = contextManager;
    }

    public static ExecutorService getEventListenerExecutor() {
        return EVENT_LISTENER_EXECUTOR;
    }

    static {
        EVENT_LISTENER_EXECUTOR = Executors.newCachedThreadPool(new ThreadFactoryBuilder().setDaemon(true).setNameFormat("Pipeline-EventListener-%d").build());
    }
}

