/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.data.pipeline.core.datasource;

import java.sql.SQLException;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import lombok.Generated;
import org.apache.shardingsphere.data.pipeline.api.datasource.PipelineDataSourceManager;
import org.apache.shardingsphere.data.pipeline.api.datasource.PipelineDataSourceWrapper;
import org.apache.shardingsphere.data.pipeline.api.datasource.config.PipelineDataSourceConfiguration;
import org.apache.shardingsphere.data.pipeline.core.datasource.PipelineDataSourceFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DefaultPipelineDataSourceManager
implements PipelineDataSourceManager {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DefaultPipelineDataSourceManager.class);
    private final Map<PipelineDataSourceConfiguration, PipelineDataSourceWrapper> cachedDataSources = new ConcurrentHashMap<PipelineDataSourceConfiguration, PipelineDataSourceWrapper>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PipelineDataSourceWrapper getDataSource(PipelineDataSourceConfiguration dataSourceConfig) {
        PipelineDataSourceWrapper result = this.cachedDataSources.get(dataSourceConfig);
        if (null != result) {
            return result;
        }
        Map<PipelineDataSourceConfiguration, PipelineDataSourceWrapper> map = this.cachedDataSources;
        synchronized (map) {
            result = this.cachedDataSources.get(dataSourceConfig);
            if (null != result) {
                return result;
            }
            result = PipelineDataSourceFactory.newInstance(dataSourceConfig);
            this.cachedDataSources.put(dataSourceConfig, result);
            return result;
        }
    }

    public void close() {
        for (PipelineDataSourceWrapper each : this.cachedDataSources.values()) {
            try {
                each.close();
            }
            catch (SQLException ex) {
                log.error("An exception occurred while closing the data source", (Throwable)ex);
            }
        }
        this.cachedDataSources.clear();
    }
}

