/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.data.pipeline.core.execute;

import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.shardingsphere.data.pipeline.core.execute.ShardingSphereDataScheduleCollector;
import org.apache.shardingsphere.infra.config.props.ConfigurationPropertyKey;
import org.apache.shardingsphere.mode.manager.ContextManager;

public final class ShardingSphereDataJobWorker {
    private static final AtomicBoolean WORKER_INITIALIZED = new AtomicBoolean(false);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void initialize(ContextManager contextManager) {
        if (WORKER_INITIALIZED.get()) {
            return;
        }
        AtomicBoolean atomicBoolean = WORKER_INITIALIZED;
        synchronized (atomicBoolean) {
            if (WORKER_INITIALIZED.get()) {
                return;
            }
            boolean collectorEnabled = (Boolean)contextManager.getMetaDataContexts().getMetaData().getProps().getValue((Enum)ConfigurationPropertyKey.PROXY_METADATA_COLLECTOR_ENABLED);
            if (collectorEnabled) {
                ShardingSphereDataJobWorker.startScheduleThread(contextManager);
            }
            WORKER_INITIALIZED.set(true);
        }
    }

    private static void startScheduleThread(ContextManager contextManager) {
        new ShardingSphereDataScheduleCollector(contextManager).start();
    }
}

