/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.data.pipeline.core.execute;

import java.sql.SQLException;
import java.util.Collection;
import java.util.Optional;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import lombok.Generated;
import org.apache.shardingsphere.data.pipeline.spi.data.collector.ShardingSphereDataCollector;
import org.apache.shardingsphere.data.pipeline.spi.data.collector.ShardingSphereDataCollectorFactory;
import org.apache.shardingsphere.infra.database.type.DatabaseType;
import org.apache.shardingsphere.infra.database.type.dialect.MySQLDatabaseType;
import org.apache.shardingsphere.infra.database.type.dialect.OpenGaussDatabaseType;
import org.apache.shardingsphere.infra.database.type.dialect.PostgreSQLDatabaseType;
import org.apache.shardingsphere.infra.executor.kernel.thread.ExecutorThreadFactoryBuilder;
import org.apache.shardingsphere.infra.metadata.ShardingSphereMetaData;
import org.apache.shardingsphere.infra.metadata.data.ShardingSphereData;
import org.apache.shardingsphere.infra.metadata.data.ShardingSphereSchemaData;
import org.apache.shardingsphere.infra.metadata.data.ShardingSphereTableData;
import org.apache.shardingsphere.infra.metadata.data.event.ShardingSphereSchemaDataAlteredEvent;
import org.apache.shardingsphere.infra.metadata.database.ShardingSphereDatabase;
import org.apache.shardingsphere.infra.metadata.database.schema.decorator.model.ShardingSphereTable;
import org.apache.shardingsphere.mode.manager.ContextManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ShardingSphereDataScheduleCollector {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ShardingSphereDataScheduleCollector.class);
    private static final String SHARDING_SPHERE = "shardingsphere";
    private final ScheduledExecutorService dataCollectorExecutor = Executors.newSingleThreadScheduledExecutor(ExecutorThreadFactoryBuilder.build((String)"data-collect-%d"));
    private final ContextManager contextManager;

    public void start() {
        this.dataCollectorExecutor.scheduleWithFixedDelay(new ShardingSphereDataCollectorRunnable(this.contextManager), 0L, 30L, TimeUnit.SECONDS);
    }

    @Generated
    public ShardingSphereDataScheduleCollector(ContextManager contextManager) {
        this.contextManager = contextManager;
    }

    private static final class ShardingSphereDataCollectorRunnable
    implements Runnable {
        private final ContextManager contextManager;

        @Override
        public void run() {
            ShardingSphereData shardingSphereData = this.contextManager.getMetaDataContexts().getShardingSphereData();
            ShardingSphereMetaData metaData = this.contextManager.getMetaDataContexts().getMetaData();
            DatabaseType databaseType = ((ShardingSphereDatabase)metaData.getDatabases().values().iterator().next()).getProtocolType();
            if (databaseType instanceof MySQLDatabaseType) {
                this.collectForMySQL(shardingSphereData, metaData, databaseType);
            } else if (databaseType instanceof PostgreSQLDatabaseType || databaseType instanceof OpenGaussDatabaseType) {
                this.collectForPostgreSQL(shardingSphereData, metaData, databaseType);
            }
        }

        private void collectForMySQL(ShardingSphereData shardingSphereData, ShardingSphereMetaData metaData, DatabaseType databaseType) {
            Optional<Collection> shardingSphereTables = Optional.ofNullable(metaData.getDatabase(ShardingSphereDataScheduleCollector.SHARDING_SPHERE)).map(database -> database.getSchema(ShardingSphereDataScheduleCollector.SHARDING_SPHERE)).map(schema -> schema.getTables().values());
            shardingSphereTables.ifPresent(tables -> tables.forEach(table -> metaData.getDatabases().forEach((key, value) -> {
                if (!databaseType.getSystemDatabaseSchemaMap().containsKey(key)) {
                    this.collectAndSendEvent(shardingSphereData, (ShardingSphereTable)table, (ShardingSphereDatabase)value, databaseType);
                }
            })));
        }

        private void collectForPostgreSQL(ShardingSphereData shardingSphereData, ShardingSphereMetaData metaData, DatabaseType databaseType) {
            metaData.getDatabases().forEach((key, value) -> {
                if (!databaseType.getSystemDatabaseSchemaMap().containsKey(key)) {
                    Optional<Collection> shardingSphereTables = Optional.ofNullable(value.getSchema(ShardingSphereDataScheduleCollector.SHARDING_SPHERE)).map(schema -> schema.getTables().values());
                    shardingSphereTables.ifPresent(tables -> tables.forEach(table -> this.collectAndSendEvent(shardingSphereData, (ShardingSphereTable)table, (ShardingSphereDatabase)value, databaseType)));
                }
            });
        }

        private void collectAndSendEvent(ShardingSphereData shardingSphereData, ShardingSphereTable table, ShardingSphereDatabase database, DatabaseType databaseType) {
            String databaseName = database.getName();
            Optional shardingSphereDataCollector = ShardingSphereDataCollectorFactory.findInstance((String)table.getName());
            if (!shardingSphereDataCollector.isPresent()) {
                return;
            }
            Optional tableData = Optional.empty();
            try {
                tableData = ((ShardingSphereDataCollector)shardingSphereDataCollector.get()).collect(database, table);
            }
            catch (SQLException ex) {
                log.error("Collect data for sharding_table_statistics error!", (Throwable)ex);
            }
            tableData.ifPresent(optional -> this.updateAndSendEvent(shardingSphereData, table.getName(), (ShardingSphereTableData)optional, databaseType, databaseName));
        }

        private void updateAndSendEvent(ShardingSphereData shardingSphereData, String tableName, ShardingSphereTableData changedTableData, DatabaseType databaseType, String databaseName) {
            Optional<ShardingSphereTableData> originTableData = this.getOriginTableData(shardingSphereData, tableName, databaseName, databaseType);
            if (originTableData.isPresent() && originTableData.get().equals((Object)changedTableData)) {
                return;
            }
            Optional<String> shardingSphereDataDatabaseName = this.findShardingSphereDatabaseName(databaseName, databaseType);
            if (!shardingSphereDataDatabaseName.isPresent()) {
                return;
            }
            Optional.ofNullable(shardingSphereData.getDatabaseData().get(shardingSphereDataDatabaseName.get())).map(database -> (ShardingSphereSchemaData)database.getSchemaData().get(ShardingSphereDataScheduleCollector.SHARDING_SPHERE)).ifPresent(shardingSphereSchemaData -> shardingSphereSchemaData.getTableData().put(tableName, changedTableData));
            ShardingSphereSchemaDataAlteredEvent event = new ShardingSphereSchemaDataAlteredEvent(shardingSphereDataDatabaseName.get(), ShardingSphereDataScheduleCollector.SHARDING_SPHERE);
            event.getAlteredTables().add(changedTableData);
            this.contextManager.getInstanceContext().getEventBusContext().post((Object)event);
        }

        private Optional<ShardingSphereTableData> getOriginTableData(ShardingSphereData shardingSphereData, String tableName, String databaseName, DatabaseType databaseType) {
            Optional<String> shardingSphereDataDatabaseName = this.findShardingSphereDatabaseName(databaseName, databaseType);
            return shardingSphereDataDatabaseName.flatMap(optional -> Optional.ofNullable(shardingSphereData.getDatabaseData().get(optional)).map(database -> (ShardingSphereSchemaData)database.getSchemaData().get(ShardingSphereDataScheduleCollector.SHARDING_SPHERE)).map(shardingSphereSchemaData -> (ShardingSphereTableData)shardingSphereSchemaData.getTableData().get(tableName)));
        }

        private Optional<String> findShardingSphereDatabaseName(String databaseName, DatabaseType databaseType) {
            if (databaseType instanceof MySQLDatabaseType) {
                return Optional.of(ShardingSphereDataScheduleCollector.SHARDING_SPHERE);
            }
            if (databaseType instanceof PostgreSQLDatabaseType || databaseType instanceof OpenGaussDatabaseType) {
                return Optional.of(databaseName);
            }
            return Optional.empty();
        }

        @Generated
        public ShardingSphereDataCollectorRunnable(ContextManager contextManager) {
            this.contextManager = contextManager;
        }
    }
}

