/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.data.pipeline.core.importer;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.shardingsphere.data.pipeline.api.ingest.record.Column;
import org.apache.shardingsphere.data.pipeline.api.ingest.record.DataRecord;
import org.apache.shardingsphere.data.pipeline.api.ingest.record.GroupedDataRecord;
import org.apache.shardingsphere.data.pipeline.core.exception.data.PipelineUnexpectedDataRecordOrderException;
import org.apache.shardingsphere.data.pipeline.core.record.RecordUtil;
import org.apache.shardingsphere.infra.util.exception.ShardingSpherePreconditions;
import org.apache.shardingsphere.infra.util.exception.external.sql.type.generic.UnsupportedSQLOperationException;

public final class DataRecordMerger {
    public List<DataRecord> merge(List<DataRecord> dataRecords) {
        HashMap result = new HashMap();
        dataRecords.forEach(each -> {
            if ("INSERT".equals(each.getType())) {
                this.mergeInsert((DataRecord)each, result);
            } else if ("UPDATE".equals(each.getType())) {
                this.mergeUpdate((DataRecord)each, result);
            } else if ("DELETE".equals(each.getType())) {
                this.mergeDelete((DataRecord)each, result);
            }
        });
        return new ArrayList<DataRecord>(result.values());
    }

    public List<GroupedDataRecord> group(List<DataRecord> dataRecords) {
        List<DataRecord> mergedDataRecords = this.merge(dataRecords);
        ArrayList<GroupedDataRecord> result = new ArrayList<GroupedDataRecord>(100);
        Map<String, List<DataRecord>> tableGroup = mergedDataRecords.stream().collect(Collectors.groupingBy(DataRecord::getTableName));
        for (Map.Entry<String, List<DataRecord>> entry : tableGroup.entrySet()) {
            Map<String, List<DataRecord>> typeGroup = entry.getValue().stream().collect(Collectors.groupingBy(DataRecord::getType));
            result.add(new GroupedDataRecord(entry.getKey(), typeGroup.get("INSERT"), typeGroup.get("UPDATE"), typeGroup.get("DELETE")));
        }
        return result;
    }

    private void mergeInsert(DataRecord dataRecord, Map<DataRecord.Key, DataRecord> dataRecords) {
        DataRecord beforeDataRecord = dataRecords.get(dataRecord.getKey());
        ShardingSpherePreconditions.checkState((null == beforeDataRecord || "DELETE".equals(beforeDataRecord.getType()) ? 1 : 0) != 0, () -> new PipelineUnexpectedDataRecordOrderException(beforeDataRecord, dataRecord));
        dataRecords.put(dataRecord.getKey(), dataRecord);
    }

    private void mergeUpdate(DataRecord dataRecord, Map<DataRecord.Key, DataRecord> dataRecords) {
        DataRecord beforeDataRecord;
        DataRecord dataRecord2 = beforeDataRecord = this.checkUpdatedPrimaryKey(dataRecord) ? dataRecords.get(dataRecord.getOldKey()) : dataRecords.get(dataRecord.getKey());
        if (null == beforeDataRecord) {
            dataRecords.put(dataRecord.getKey(), dataRecord);
            return;
        }
        ShardingSpherePreconditions.checkState((!"DELETE".equals(beforeDataRecord.getType()) ? 1 : 0) != 0, () -> new UnsupportedSQLOperationException("Not Delete"));
        if (this.checkUpdatedPrimaryKey(dataRecord)) {
            dataRecords.remove(dataRecord.getOldKey());
        }
        if ("INSERT".equals(beforeDataRecord.getType())) {
            DataRecord mergedDataRecord = this.mergeColumn(beforeDataRecord, dataRecord);
            mergedDataRecord.setTableName(dataRecord.getTableName());
            mergedDataRecord.setType("INSERT");
            dataRecords.put(mergedDataRecord.getKey(), mergedDataRecord);
            return;
        }
        if ("UPDATE".equals(beforeDataRecord.getType())) {
            DataRecord mergedDataRecord = this.mergeColumn(beforeDataRecord, dataRecord);
            mergedDataRecord.setTableName(dataRecord.getTableName());
            mergedDataRecord.setType("UPDATE");
            dataRecords.put(mergedDataRecord.getKey(), mergedDataRecord);
        }
    }

    private void mergeDelete(DataRecord dataRecord, Map<DataRecord.Key, DataRecord> dataRecords) {
        DataRecord beforeDataRecord = dataRecords.get(dataRecord.getKey());
        ShardingSpherePreconditions.checkState((null == beforeDataRecord || !"DELETE".equals(beforeDataRecord.getType()) ? 1 : 0) != 0, () -> new PipelineUnexpectedDataRecordOrderException(beforeDataRecord, dataRecord));
        if (null != beforeDataRecord && "UPDATE".equals(beforeDataRecord.getType()) && this.checkUpdatedPrimaryKey(beforeDataRecord)) {
            DataRecord mergedDataRecord = new DataRecord(dataRecord.getPosition(), dataRecord.getColumnCount());
            for (int i = 0; i < dataRecord.getColumnCount(); ++i) {
                mergedDataRecord.addColumn(new Column(dataRecord.getColumn(i).getName(), dataRecord.getColumn(i).isUniqueKey() ? beforeDataRecord.getColumn(i).getOldValue() : beforeDataRecord.getColumn(i).getValue(), true, dataRecord.getColumn(i).isUniqueKey()));
            }
            mergedDataRecord.setTableName(dataRecord.getTableName());
            mergedDataRecord.setType("DELETE");
            dataRecords.remove(beforeDataRecord.getKey());
            dataRecords.put(mergedDataRecord.getKey(), mergedDataRecord);
        } else {
            dataRecords.put(dataRecord.getKey(), dataRecord);
        }
    }

    private boolean checkUpdatedPrimaryKey(DataRecord dataRecord) {
        return RecordUtil.extractPrimaryColumns(dataRecord).stream().anyMatch(Column::isUpdated);
    }

    private DataRecord mergeColumn(DataRecord preDataRecord, DataRecord curDataRecord) {
        DataRecord result = new DataRecord(curDataRecord.getPosition(), curDataRecord.getColumnCount());
        for (int i = 0; i < curDataRecord.getColumnCount(); ++i) {
            result.addColumn(new Column(curDataRecord.getColumn(i).getName(), preDataRecord.getColumn(i).isUniqueKey() ? this.mergePrimaryKeyOldValue(preDataRecord.getColumn(i), curDataRecord.getColumn(i)) : null, curDataRecord.getColumn(i).getValue(), preDataRecord.getColumn(i).isUpdated() || curDataRecord.getColumn(i).isUpdated(), curDataRecord.getColumn(i).isUniqueKey()));
        }
        return result;
    }

    private Object mergePrimaryKeyOldValue(Column beforeColumn, Column column) {
        return beforeColumn.isUpdated() ? beforeColumn.getOldValue() : (column.isUpdated() ? column.getOldValue() : null);
    }
}

