/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.data.pipeline.core.ingest.channel.memory;

import com.google.common.base.Strings;
import java.util.Properties;
import lombok.Generated;
import org.apache.shardingsphere.data.pipeline.api.ingest.channel.AckCallback;
import org.apache.shardingsphere.data.pipeline.api.ingest.channel.PipelineChannel;
import org.apache.shardingsphere.data.pipeline.core.ingest.channel.memory.MultiplexMemoryPipelineChannel;
import org.apache.shardingsphere.data.pipeline.core.ingest.channel.memory.SimpleMemoryPipelineChannel;
import org.apache.shardingsphere.data.pipeline.spi.ingest.channel.PipelineChannelCreator;

public final class MemoryPipelineChannelCreator
implements PipelineChannelCreator {
    public static final String TYPE = "MEMORY";
    public static final int BLOCK_QUEUE_SIZE_DEFAULT_VALUE = 10000;
    public static final String BLOCK_QUEUE_SIZE_KEY = "block-queue-size";
    private Properties props;
    private int blockQueueSize = 10000;

    public void init(Properties props) {
        this.props = props;
        String blockQueueSizeValue = props.getProperty(BLOCK_QUEUE_SIZE_KEY);
        if (!Strings.isNullOrEmpty((String)blockQueueSizeValue)) {
            this.blockQueueSize = Integer.parseInt(blockQueueSizeValue);
        }
    }

    public PipelineChannel createPipelineChannel(int outputConcurrency, AckCallback ackCallback) {
        return 1 == outputConcurrency ? new SimpleMemoryPipelineChannel(this.blockQueueSize, ackCallback) : new MultiplexMemoryPipelineChannel(outputConcurrency, this.blockQueueSize, ackCallback);
    }

    public String getType() {
        return TYPE;
    }

    @Generated
    public Properties getProps() {
        return this.props;
    }
}

