/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.data.pipeline.core.ingest.dumper;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.Optional;
import javax.sql.DataSource;
import lombok.Generated;
import org.apache.shardingsphere.data.pipeline.api.config.ingest.InventoryDumperConfiguration;
import org.apache.shardingsphere.data.pipeline.api.datasource.config.impl.StandardPipelineDataSourceConfiguration;
import org.apache.shardingsphere.data.pipeline.api.executor.AbstractLifecycleExecutor;
import org.apache.shardingsphere.data.pipeline.api.ingest.channel.PipelineChannel;
import org.apache.shardingsphere.data.pipeline.api.ingest.dumper.Dumper;
import org.apache.shardingsphere.data.pipeline.api.ingest.position.FinishedPosition;
import org.apache.shardingsphere.data.pipeline.api.ingest.position.IngestPosition;
import org.apache.shardingsphere.data.pipeline.api.ingest.position.PlaceholderPosition;
import org.apache.shardingsphere.data.pipeline.api.ingest.position.PrimaryKeyPosition;
import org.apache.shardingsphere.data.pipeline.api.ingest.position.PrimaryKeyPositionFactory;
import org.apache.shardingsphere.data.pipeline.api.ingest.record.Column;
import org.apache.shardingsphere.data.pipeline.api.ingest.record.DataRecord;
import org.apache.shardingsphere.data.pipeline.api.ingest.record.FinishedRecord;
import org.apache.shardingsphere.data.pipeline.api.ingest.record.Record;
import org.apache.shardingsphere.data.pipeline.api.metadata.LogicTableName;
import org.apache.shardingsphere.data.pipeline.api.metadata.loader.PipelineTableMetaDataLoader;
import org.apache.shardingsphere.data.pipeline.api.metadata.model.PipelineTableMetaData;
import org.apache.shardingsphere.data.pipeline.core.exception.data.UnsupportedPipelineJobUniqueKeyDataTypeException;
import org.apache.shardingsphere.data.pipeline.core.ingest.dumper.ColumnValueReaderFactory;
import org.apache.shardingsphere.data.pipeline.core.ingest.exception.IngestException;
import org.apache.shardingsphere.data.pipeline.core.sqlbuilder.PipelineSQLBuilderFactory;
import org.apache.shardingsphere.data.pipeline.core.util.PipelineJdbcUtils;
import org.apache.shardingsphere.data.pipeline.spi.ingest.dumper.ColumnValueReader;
import org.apache.shardingsphere.data.pipeline.spi.sqlbuilder.PipelineSQLBuilder;
import org.apache.shardingsphere.infra.util.exception.ShardingSpherePreconditions;
import org.apache.shardingsphere.infra.util.exception.external.sql.type.generic.UnsupportedSQLOperationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class InventoryDumper
extends AbstractLifecycleExecutor
implements Dumper {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(InventoryDumper.class);
    private final InventoryDumperConfiguration dumperConfig;
    private final PipelineChannel channel;
    private final DataSource dataSource;
    private final PipelineSQLBuilder sqlBuilder;
    private final ColumnValueReader columnValueReader;
    private final PipelineTableMetaDataLoader metaDataLoader;

    public InventoryDumper(InventoryDumperConfiguration dumperConfig, PipelineChannel channel, DataSource dataSource, PipelineTableMetaDataLoader metaDataLoader) {
        ShardingSpherePreconditions.checkState((boolean)StandardPipelineDataSourceConfiguration.class.equals(dumperConfig.getDataSourceConfig().getClass()), () -> new UnsupportedSQLOperationException("AbstractInventoryDumper only support StandardPipelineDataSourceConfiguration"));
        this.dumperConfig = dumperConfig;
        this.channel = channel;
        this.dataSource = dataSource;
        this.sqlBuilder = PipelineSQLBuilderFactory.getInstance(dumperConfig.getDataSourceConfig().getDatabaseType().getType());
        this.columnValueReader = ColumnValueReaderFactory.getInstance(dumperConfig.getDataSourceConfig().getDatabaseType().getType());
        this.metaDataLoader = metaDataLoader;
    }

    protected void runBlocking() {
        String firstSQL = this.buildInventoryDumpSQL(true);
        String laterSQL = this.buildInventoryDumpSQL(false);
        IngestPosition position = this.dumperConfig.getPosition();
        log.info("Inventory dump, uniqueKeyDataType={}, firstSQL={}, laterSQL={}, position={}.", new Object[]{this.dumperConfig.getUniqueKeyDataType(), firstSQL, laterSQL, position});
        if (position instanceof FinishedPosition) {
            log.info("Ignored because of already finished.");
            return;
        }
        PipelineTableMetaData tableMetaData = this.metaDataLoader.getTableMetaData(this.dumperConfig.getSchemaName(new LogicTableName(this.dumperConfig.getLogicTableName())), this.dumperConfig.getActualTableName());
        Object beginUniqueKeyValue = ((PrimaryKeyPosition)position).getBeginValue();
        int round = 1;
        try (Connection connection = this.dataSource.getConnection();){
            Optional<Object> maxUniqueKeyValue;
            while ((maxUniqueKeyValue = this.dump(tableMetaData, connection, 1 == round ? firstSQL : laterSQL, beginUniqueKeyValue, round++)).isPresent()) {
                beginUniqueKeyValue = maxUniqueKeyValue.get();
                if (this.isRunning()) continue;
                log.info("Broke because of inventory dump is not running.");
                break;
            }
            log.info("Inventory dump done, round={}, maxUniqueKeyValue={}.", (Object)round, maxUniqueKeyValue);
        }
        catch (SQLException ex) {
            log.error("Inventory dump, ex caught, msg={}.", (Object)ex.getMessage());
            throw new IngestException(ex);
        }
        finally {
            log.info("Inventory dump, before put FinishedRecord.");
            this.channel.pushRecord((Record)new FinishedRecord((IngestPosition)new FinishedPosition()));
        }
    }

    private String buildInventoryDumpSQL(boolean firstQuery) {
        String schemaName = this.dumperConfig.getSchemaName(new LogicTableName(this.dumperConfig.getLogicTableName()));
        if (PipelineJdbcUtils.isIntegerColumn(this.dumperConfig.getUniqueKeyDataType())) {
            return this.sqlBuilder.buildDivisibleInventoryDumpSQL(schemaName, this.dumperConfig.getActualTableName(), this.dumperConfig.getUniqueKey(), this.dumperConfig.getUniqueKeyDataType().intValue(), firstQuery);
        }
        if (PipelineJdbcUtils.isStringColumn(this.dumperConfig.getUniqueKeyDataType())) {
            return this.sqlBuilder.buildIndivisibleInventoryDumpSQL(schemaName, this.dumperConfig.getActualTableName(), this.dumperConfig.getUniqueKey(), this.dumperConfig.getUniqueKeyDataType().intValue(), firstQuery);
        }
        throw new UnsupportedPipelineJobUniqueKeyDataTypeException(this.dumperConfig.getUniqueKeyDataType());
    }

    /*
     * Exception decompiling
     */
    private Optional<Object> dump(PipelineTableMetaData tableMetaData, Connection connection, String sql, Object beginUniqueKeyValue, int round) throws SQLException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void setParameters(PreparedStatement preparedStatement, int batchSize, Object beginUniqueKeyValue) throws SQLException {
        preparedStatement.setFetchSize(batchSize);
        if (PipelineJdbcUtils.isIntegerColumn(this.dumperConfig.getUniqueKeyDataType())) {
            preparedStatement.setObject(1, beginUniqueKeyValue);
            preparedStatement.setObject(2, ((PrimaryKeyPosition)this.dumperConfig.getPosition()).getEndValue());
            preparedStatement.setInt(3, batchSize);
            return;
        }
        if (PipelineJdbcUtils.isStringColumn(this.dumperConfig.getUniqueKeyDataType())) {
            preparedStatement.setObject(1, beginUniqueKeyValue);
            preparedStatement.setInt(2, batchSize);
            return;
        }
        throw new UnsupportedPipelineJobUniqueKeyDataTypeException(this.dumperConfig.getUniqueKeyDataType());
    }

    private DataRecord loadDataRecord(ResultSet resultSet, ResultSetMetaData resultSetMetaData, PipelineTableMetaData tableMetaData) throws SQLException {
        int columnCount = resultSetMetaData.getColumnCount();
        DataRecord result = new DataRecord(this.newPosition(resultSet), columnCount);
        result.setType("INSERT");
        result.setTableName(this.dumperConfig.getLogicTableName());
        for (int i = 1; i <= columnCount; ++i) {
            result.addColumn(new Column(resultSetMetaData.getColumnName(i), this.columnValueReader.readValue(resultSet, resultSetMetaData, i), true, tableMetaData.getColumnMetaData(i).isUniqueKey()));
        }
        return result;
    }

    private IngestPosition<?> newPosition(ResultSet resultSet) throws SQLException {
        return null == this.dumperConfig.getUniqueKey() ? new PlaceholderPosition() : PrimaryKeyPositionFactory.newInstance((Object)resultSet.getObject(this.dumperConfig.getUniqueKey()), (Object)((PrimaryKeyPosition)this.dumperConfig.getPosition()).getEndValue());
    }

    protected void doStop() {
    }

    @Generated
    protected InventoryDumperConfiguration getDumperConfig() {
        return this.dumperConfig;
    }
}

