/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.data.pipeline.core.job;

import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import lombok.Generated;
import org.apache.shardingsphere.data.pipeline.api.job.PipelineJob;
import org.apache.shardingsphere.data.pipeline.api.task.PipelineTasksRunner;
import org.apache.shardingsphere.elasticjob.lite.api.bootstrap.JobBootstrap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractPipelineJob
implements PipelineJob {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AbstractPipelineJob.class);
    private volatile String jobId;
    private volatile boolean stopping;
    private volatile JobBootstrap jobBootstrap;
    private final Map<Integer, PipelineTasksRunner> tasksRunnerMap = new ConcurrentHashMap<Integer, PipelineTasksRunner>();

    protected void runInBackground(Runnable runnable) {
        new Thread(runnable).start();
    }

    public Optional<PipelineTasksRunner> getTasksRunner(int shardingItem) {
        return Optional.ofNullable(this.tasksRunnerMap.get(shardingItem));
    }

    @Generated
    public String getJobId() {
        return this.jobId;
    }

    @Generated
    public boolean isStopping() {
        return this.stopping;
    }

    @Generated
    public JobBootstrap getJobBootstrap() {
        return this.jobBootstrap;
    }

    @Generated
    public Map<Integer, PipelineTasksRunner> getTasksRunnerMap() {
        return this.tasksRunnerMap;
    }

    @Generated
    public void setJobId(String jobId) {
        this.jobId = jobId;
    }

    @Generated
    public void setStopping(boolean stopping) {
        this.stopping = stopping;
    }

    @Generated
    public void setJobBootstrap(JobBootstrap jobBootstrap) {
        this.jobBootstrap = jobBootstrap;
    }
}

