/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.data.pipeline.core.job;

import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import lombok.Generated;
import org.apache.shardingsphere.data.pipeline.api.context.PipelineJobItemContext;
import org.apache.shardingsphere.data.pipeline.api.job.PipelineJob;
import org.apache.shardingsphere.data.pipeline.api.task.PipelineTasksRunner;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class PipelineJobCenter {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(PipelineJobCenter.class);
    private static final Map<String, PipelineJob> JOB_MAP = new ConcurrentHashMap<String, PipelineJob>();

    public static void addJob(String jobId, PipelineJob job) {
        log.info("add job, jobId={}", (Object)jobId);
        JOB_MAP.put(jobId, job);
    }

    public static boolean isJobExisting(String jobId) {
        return JOB_MAP.containsKey(jobId);
    }

    public static void stop(String jobId) {
        PipelineJob job = JOB_MAP.get(jobId);
        if (null == job) {
            log.info("job is null, ignore, jobId={}", (Object)jobId);
            return;
        }
        job.stop();
        log.info("remove job, jobId={}", (Object)jobId);
        JOB_MAP.remove(jobId);
    }

    public static Optional<PipelineJobItemContext> getJobItemContext(String jobId, int shardingItem) {
        PipelineJob job = JOB_MAP.get(jobId);
        if (null == job) {
            return Optional.empty();
        }
        Optional tasksRunner = job.getTasksRunner(shardingItem);
        return tasksRunner.map(PipelineTasksRunner::getJobItemContext);
    }
}

