/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.data.pipeline.core.job;

import com.google.common.base.Preconditions;
import lombok.Generated;
import org.apache.shardingsphere.data.pipeline.api.job.JobType;
import org.apache.shardingsphere.data.pipeline.api.job.PipelineJobId;

public final class PipelineJobIdUtils {
    public static String marshalJobIdCommonPrefix(PipelineJobId pipelineJobId) {
        return 'j' + pipelineJobId.getJobTypeCode() + pipelineJobId.getFormatVersion();
    }

    public static JobType parseJobType(String jobId) {
        Preconditions.checkArgument((jobId.length() > 3 ? 1 : 0) != 0, (String)"Invalid jobId length, jobId=%s", (Object)jobId);
        Preconditions.checkArgument(('j' == jobId.charAt(0) ? 1 : 0) != 0, (String)"Invalid jobId, first char=%s", (char)jobId.charAt(0));
        String typeCode = jobId.substring(1, 3);
        JobType result = JobType.valueOfByCode((String)typeCode);
        Preconditions.checkNotNull((Object)result, (String)"Can not get job type by `%s`, job ID is `%s`", (Object)typeCode, (Object)jobId);
        return result;
    }

    @Generated
    private PipelineJobIdUtils() {
    }
}

