/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.data.pipeline.core.job.progress;

import java.util.Collection;
import lombok.Generated;
import org.apache.shardingsphere.data.pipeline.api.ingest.position.FinishedPosition;
import org.apache.shardingsphere.data.pipeline.api.job.JobStatus;
import org.apache.shardingsphere.data.pipeline.api.job.progress.PipelineJobItemProgress;
import org.apache.shardingsphere.data.pipeline.core.task.InventoryTask;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class PipelineJobProgressDetector {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(PipelineJobProgressDetector.class);

    public static boolean allInventoryTasksFinished(Collection<InventoryTask> inventoryTasks) {
        if (inventoryTasks.isEmpty()) {
            log.warn("inventoryTasks is empty");
        }
        return inventoryTasks.stream().allMatch(each -> each.getTaskProgress().getPosition() instanceof FinishedPosition);
    }

    public static boolean isJobCompleted(int jobShardingCount, Collection<? extends PipelineJobItemProgress> jobItemProgresses) {
        return jobShardingCount == jobItemProgresses.size() && jobItemProgresses.stream().allMatch(each -> null != each && !each.getStatus().isRunning());
    }

    public static boolean isJobSuccessful(int jobShardingCount, Collection<? extends PipelineJobItemProgress> jobItemProgresses) {
        return jobShardingCount == jobItemProgresses.size() && jobItemProgresses.stream().allMatch(each -> null != each && JobStatus.FINISHED == each.getStatus());
    }

    @Generated
    private PipelineJobProgressDetector() {
    }
}

