/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.data.pipeline.core.job.progress.persist;

import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import lombok.Generated;
import org.apache.shardingsphere.data.pipeline.api.context.PipelineJobItemContext;
import org.apache.shardingsphere.data.pipeline.core.api.PipelineAPIFactory;
import org.apache.shardingsphere.data.pipeline.core.job.PipelineJobCenter;
import org.apache.shardingsphere.data.pipeline.core.job.PipelineJobIdUtils;
import org.apache.shardingsphere.data.pipeline.core.job.progress.persist.PipelineJobProgressPersistContext;
import org.apache.shardingsphere.infra.executor.kernel.thread.ExecutorThreadFactoryBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class PipelineJobProgressPersistService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(PipelineJobProgressPersistService.class);
    private static final Map<String, Map<Integer, PipelineJobProgressPersistContext>> JOB_PROGRESS_PERSIST_MAP = new ConcurrentHashMap<String, Map<Integer, PipelineJobProgressPersistContext>>();
    private static final ScheduledExecutorService JOB_PERSIST_EXECUTOR = Executors.newSingleThreadScheduledExecutor(ExecutorThreadFactoryBuilder.build((String)"pipeline-progress-persist-%d"));
    private static final long DELAY_SECONDS = 1L;

    public static void removeJobProgressPersistContext(String jobId) {
        log.info("Remove job progress persist context, jobId={}", (Object)jobId);
        JOB_PROGRESS_PERSIST_MAP.remove(jobId);
    }

    public static void addJobProgressPersistContext(String jobId, int shardingItem) {
        log.info("Add job progress persist context, jobId={}, shardingItem={}", (Object)jobId, (Object)shardingItem);
        JOB_PROGRESS_PERSIST_MAP.computeIfAbsent(jobId, key -> new ConcurrentHashMap()).put(shardingItem, new PipelineJobProgressPersistContext(jobId, shardingItem));
    }

    public static void notifyPersist(String jobId, int shardingItem) {
        Map persistContextMap = JOB_PROGRESS_PERSIST_MAP.getOrDefault(jobId, Collections.emptyMap());
        PipelineJobProgressPersistContext persistContext = (PipelineJobProgressPersistContext)persistContextMap.get(shardingItem);
        if (null == persistContext) {
            log.debug("persistContext is null, jobId={}, shardingItem={}", (Object)jobId, (Object)shardingItem);
            return;
        }
        persistContext.getHasNewEvents().set(true);
    }

    private static void persist(String jobId, int shardingItem, PipelineJobProgressPersistContext persistContext) {
        Long beforePersistingProgressMillis = persistContext.getBeforePersistingProgressMillis().get();
        if (!(null != beforePersistingProgressMillis && System.currentTimeMillis() - beforePersistingProgressMillis >= TimeUnit.SECONDS.toMillis(1L) || persistContext.getHasNewEvents().get())) {
            return;
        }
        Optional<PipelineJobItemContext> jobItemContext = PipelineJobCenter.getJobItemContext(jobId, shardingItem);
        if (!jobItemContext.isPresent()) {
            return;
        }
        if (null == beforePersistingProgressMillis) {
            persistContext.getBeforePersistingProgressMillis().set(System.currentTimeMillis());
        }
        persistContext.getHasNewEvents().set(false);
        long startTimeMillis = System.currentTimeMillis();
        PipelineAPIFactory.getPipelineJobAPI(PipelineJobIdUtils.parseJobType(jobId)).persistJobItemProgress(jobItemContext.get());
        persistContext.getBeforePersistingProgressMillis().set(null);
        if (6 == ThreadLocalRandom.current().nextInt(100)) {
            log.info("persist, jobId={}, shardingItem={}, cost {} ms", new Object[]{jobId, shardingItem, System.currentTimeMillis() - startTimeMillis});
        }
    }

    static {
        JOB_PERSIST_EXECUTOR.scheduleWithFixedDelay(new PersistJobContextRunnable(), 0L, 1L, TimeUnit.SECONDS);
    }

    private static final class PersistJobContextRunnable
    implements Runnable {
        private PersistJobContextRunnable() {
        }

        @Override
        public void run() {
            for (Map.Entry entry : JOB_PROGRESS_PERSIST_MAP.entrySet()) {
                ((Map)entry.getValue()).forEach((shardingItem, persistContext) -> PipelineJobProgressPersistService.persist((String)entry.getKey(), shardingItem, persistContext));
            }
        }
    }
}

