/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.data.pipeline.core.metadata.generator;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.Collections;
import java.util.Comparator;
import java.util.Map;
import java.util.Optional;
import java.util.TreeMap;
import javax.sql.DataSource;
import lombok.Generated;
import org.apache.shardingsphere.data.pipeline.spi.ddlgenerator.CreateTableSQLGeneratorFactory;
import org.apache.shardingsphere.infra.binder.QueryContext;
import org.apache.shardingsphere.infra.binder.SQLStatementContextFactory;
import org.apache.shardingsphere.infra.binder.statement.SQLStatementContext;
import org.apache.shardingsphere.infra.binder.statement.ddl.AlterTableStatementContext;
import org.apache.shardingsphere.infra.binder.statement.ddl.CommentStatementContext;
import org.apache.shardingsphere.infra.binder.statement.ddl.CreateIndexStatementContext;
import org.apache.shardingsphere.infra.binder.statement.ddl.CreateTableStatementContext;
import org.apache.shardingsphere.infra.binder.type.ConstraintAvailable;
import org.apache.shardingsphere.infra.binder.type.IndexAvailable;
import org.apache.shardingsphere.infra.binder.type.TableAvailable;
import org.apache.shardingsphere.infra.database.type.DatabaseType;
import org.apache.shardingsphere.infra.metadata.database.schema.util.IndexMetaDataUtil;
import org.apache.shardingsphere.infra.parser.ShardingSphereSQLParserEngine;
import org.apache.shardingsphere.sql.parser.sql.common.segment.SQLSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.ddl.index.IndexSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.generic.table.SimpleTableSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.generic.table.TableNameSegment;
import org.apache.shardingsphere.sql.parser.sql.common.statement.SQLStatement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class PipelineDDLGenerator {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(PipelineDDLGenerator.class);
    private static final String DELIMITER = ";";
    private static final String SET_SEARCH_PATH_PREFIX = "set search_path";

    public String generateLogicDDL(DatabaseType databaseType, DataSource sourceDataSource, String schemaName, String sourceTableName, String targetTableName, ShardingSphereSQLParserEngine parserEngine) throws SQLException {
        log.info("generateLogicDDL, databaseType={}, schemaName={}, sourceTableName={}, targetTableName={}", new Object[]{databaseType.getType(), schemaName, sourceTableName, targetTableName});
        long startTimeMillis = System.currentTimeMillis();
        StringBuilder result = new StringBuilder();
        for (String each : CreateTableSQLGeneratorFactory.getInstance((DatabaseType)databaseType).generate(sourceDataSource, schemaName, sourceTableName)) {
            Optional<String> queryContext = this.decorate(databaseType, sourceDataSource, schemaName, targetTableName, parserEngine, each);
            queryContext.ifPresent(ddlSQL -> result.append((String)ddlSQL).append(DELIMITER).append(System.lineSeparator()));
        }
        log.info("generateLogicDDL cost {} ms", (Object)(System.currentTimeMillis() - startTimeMillis));
        return result.toString();
    }

    private Optional<String> decorate(DatabaseType databaseType, DataSource dataSource, String schemaName, String targetTableName, ShardingSphereSQLParserEngine parserEngine, String sql) throws SQLException {
        String databaseName;
        if (sql.trim().isEmpty()) {
            return Optional.empty();
        }
        try (Connection connection = dataSource.getConnection();){
            databaseName = connection.getCatalog();
        }
        String result = this.decorateActualSQL(databaseName, targetTableName, parserEngine, sql.trim());
        if ("openGauss".equals(databaseType.getType())) {
            return this.decorateOpenGauss(databaseName, schemaName, result, parserEngine);
        }
        return Optional.of(result);
    }

    private String decorateActualSQL(String databaseName, String targetTableName, ShardingSphereSQLParserEngine parserEngine, String sql) {
        QueryContext queryContext = this.getQueryContext(databaseName, parserEngine, sql);
        SQLStatementContext sqlStatementContext = queryContext.getSqlStatementContext();
        TreeMap<SQLSegment, String> replaceMap = new TreeMap<SQLSegment, String>(Comparator.comparing(SQLSegment::getStartIndex));
        if (sqlStatementContext instanceof CreateTableStatementContext) {
            this.appendFromIndexAndConstraint(replaceMap, targetTableName, sqlStatementContext);
            this.appendFromTable(replaceMap, targetTableName, (TableAvailable)sqlStatementContext);
        }
        if (sqlStatementContext instanceof CommentStatementContext) {
            this.appendFromTable(replaceMap, targetTableName, (TableAvailable)sqlStatementContext);
        }
        if (sqlStatementContext instanceof CreateIndexStatementContext) {
            this.appendFromTable(replaceMap, targetTableName, (TableAvailable)sqlStatementContext);
            this.appendFromIndexAndConstraint(replaceMap, targetTableName, sqlStatementContext);
        }
        if (sqlStatementContext instanceof AlterTableStatementContext) {
            this.appendFromIndexAndConstraint(replaceMap, targetTableName, sqlStatementContext);
            this.appendFromTable(replaceMap, targetTableName, (TableAvailable)sqlStatementContext);
        }
        return this.doDecorateActualTable(replaceMap, sql);
    }

    private QueryContext getQueryContext(String databaseName, ShardingSphereSQLParserEngine parserEngine, String sql) {
        SQLStatementContext sqlStatementContext = SQLStatementContextFactory.newInstance(null, (SQLStatement)parserEngine.parse(sql, false), (String)databaseName);
        return new QueryContext(sqlStatementContext, sql, Collections.emptyList());
    }

    private void appendFromIndexAndConstraint(Map<SQLSegment, String> replaceMap, String targetTableName, SQLStatementContext<?> sqlStatementContext) {
        if (!(sqlStatementContext instanceof TableAvailable) || ((TableAvailable)sqlStatementContext).getTablesContext().getTables().isEmpty()) {
            return;
        }
        TableNameSegment tableNameSegment = ((SimpleTableSegment)((TableAvailable)sqlStatementContext).getTablesContext().getTables().iterator().next()).getTableName();
        if (!tableNameSegment.getIdentifier().getValue().equals(targetTableName)) {
            if (sqlStatementContext instanceof IndexAvailable) {
                for (IndexSegment each : ((IndexAvailable)sqlStatementContext).getIndexes()) {
                    String logicIndexName = IndexMetaDataUtil.getLogicIndexName((String)each.getIndexName().getIdentifier().getValue(), (String)tableNameSegment.getIdentifier().getValue());
                    replaceMap.put((SQLSegment)each.getIndexName(), logicIndexName);
                }
            }
            if (sqlStatementContext instanceof ConstraintAvailable) {
                for (IndexSegment each : ((ConstraintAvailable)sqlStatementContext).getConstraints()) {
                    String logicConstraint = IndexMetaDataUtil.getLogicIndexName((String)each.getIdentifier().getValue(), (String)tableNameSegment.getIdentifier().getValue());
                    replaceMap.put((SQLSegment)each, logicConstraint);
                }
            }
        }
    }

    private void appendFromTable(Map<SQLSegment, String> replaceMap, String targetTableName, TableAvailable sqlStatementContext) {
        for (SimpleTableSegment each : sqlStatementContext.getAllTables()) {
            if (targetTableName.equals(each.getTableName().getIdentifier().getValue())) continue;
            replaceMap.put((SQLSegment)each.getTableName(), targetTableName);
        }
    }

    private String doDecorateActualTable(Map<SQLSegment, String> replaceMap, String sql) {
        StringBuilder result = new StringBuilder();
        int lastStopIndex = 0;
        for (Map.Entry<SQLSegment, String> entry : replaceMap.entrySet()) {
            result.append(sql, lastStopIndex, entry.getKey().getStartIndex());
            result.append(entry.getValue());
            lastStopIndex = entry.getKey().getStopIndex() + 1;
        }
        if (lastStopIndex < sql.length()) {
            result.append(sql, lastStopIndex, sql.length());
        }
        return result.toString();
    }

    private Optional<String> decorateOpenGauss(String databaseName, String schemaName, String queryContext, ShardingSphereSQLParserEngine parserEngine) {
        if (queryContext.toLowerCase().startsWith(SET_SEARCH_PATH_PREFIX)) {
            return Optional.empty();
        }
        return Optional.of(this.replaceTableNameWithPrefix(queryContext, schemaName + ".", databaseName, parserEngine));
    }

    private String replaceTableNameWithPrefix(String sql, String prefix, String databaseName, ShardingSphereSQLParserEngine parserEngine) {
        QueryContext queryContext = this.getQueryContext(databaseName, parserEngine, sql);
        SQLStatementContext sqlStatementContext = queryContext.getSqlStatementContext();
        if (sqlStatementContext instanceof CreateTableStatementContext || sqlStatementContext instanceof CommentStatementContext || sqlStatementContext instanceof CreateIndexStatementContext || sqlStatementContext instanceof AlterTableStatementContext) {
            if (sqlStatementContext.getTablesContext().getTables().isEmpty()) {
                return sql;
            }
            TableNameSegment tableNameSegment = ((SimpleTableSegment)sqlStatementContext.getTablesContext().getTables().iterator().next()).getTableName();
            if (sqlStatementContext.getTablesContext().getSchemaName().isPresent()) {
                return sql;
            }
            TreeMap<SQLSegment, String> replaceMap = new TreeMap<SQLSegment, String>(Comparator.comparing(SQLSegment::getStartIndex));
            replaceMap.put((SQLSegment)tableNameSegment, prefix + tableNameSegment.getIdentifier().getValue());
            return this.doDecorateActualTable(replaceMap, sql);
        }
        return sql;
    }
}

