/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.data.pipeline.core.metadata.loader;

import java.util.Collection;
import java.util.List;
import lombok.Generated;
import org.apache.shardingsphere.data.pipeline.api.metadata.loader.PipelineTableMetaDataLoader;
import org.apache.shardingsphere.data.pipeline.api.metadata.model.PipelineColumnMetaData;
import org.apache.shardingsphere.data.pipeline.api.metadata.model.PipelineIndexMetaData;
import org.apache.shardingsphere.data.pipeline.api.metadata.model.PipelineTableMetaData;
import org.apache.shardingsphere.data.pipeline.core.exception.job.SplitPipelineJobByRangeException;
import org.apache.shardingsphere.infra.util.exception.ShardingSpherePreconditions;

public final class PipelineTableMetaDataUtil {
    public static PipelineColumnMetaData getUniqueKeyColumn(String schemaName, String tableName, PipelineTableMetaDataLoader metaDataLoader) {
        PipelineTableMetaData pipelineTableMetaData = metaDataLoader.getTableMetaData(schemaName, tableName);
        return PipelineTableMetaDataUtil.mustGetAnAppropriateUniqueKeyColumn(pipelineTableMetaData, tableName);
    }

    private static PipelineColumnMetaData mustGetAnAppropriateUniqueKeyColumn(PipelineTableMetaData tableMetaData, String tableName) {
        PipelineColumnMetaData column;
        ShardingSpherePreconditions.checkNotNull((Object)tableMetaData, () -> new SplitPipelineJobByRangeException(tableName, "can not get table metadata"));
        List primaryKeys = tableMetaData.getPrimaryKeyColumns();
        if (1 == primaryKeys.size()) {
            return tableMetaData.getColumnMetaData((String)tableMetaData.getPrimaryKeyColumns().get(0));
        }
        ShardingSpherePreconditions.checkState((boolean)primaryKeys.isEmpty(), () -> new SplitPipelineJobByRangeException(tableName, "primary key is union primary"));
        Collection uniqueIndexes = tableMetaData.getUniqueIndexes();
        ShardingSpherePreconditions.checkState((!uniqueIndexes.isEmpty() ? 1 : 0) != 0, () -> new SplitPipelineJobByRangeException(tableName, "no primary key or unique index"));
        if (1 == uniqueIndexes.size() && 1 == ((PipelineIndexMetaData)uniqueIndexes.iterator().next()).getColumns().size() && !(column = (PipelineColumnMetaData)((PipelineIndexMetaData)uniqueIndexes.iterator().next()).getColumns().get(0)).isNullable()) {
            return column;
        }
        throw new SplitPipelineJobByRangeException(tableName, "table contains multiple unique index or unique index contains nullable/multiple column(s)");
    }

    @Generated
    private PipelineTableMetaDataUtil() {
    }
}

