/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.data.pipeline.core.metadata.loader;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.shardingsphere.data.pipeline.api.datasource.PipelineDataSourceWrapper;
import org.apache.shardingsphere.data.pipeline.api.metadata.TableName;
import org.apache.shardingsphere.data.pipeline.api.metadata.loader.PipelineTableMetaDataLoader;
import org.apache.shardingsphere.data.pipeline.api.metadata.model.PipelineColumnMetaData;
import org.apache.shardingsphere.data.pipeline.api.metadata.model.PipelineIndexMetaData;
import org.apache.shardingsphere.data.pipeline.api.metadata.model.PipelineTableMetaData;
import org.apache.shardingsphere.infra.database.type.DatabaseTypeFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class StandardPipelineTableMetaDataLoader
implements PipelineTableMetaDataLoader {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(StandardPipelineTableMetaDataLoader.class);
    private final PipelineDataSourceWrapper dataSource;
    private final Map<TableName, PipelineTableMetaData> tableMetaDataMap = new ConcurrentHashMap<TableName, PipelineTableMetaData>();

    public PipelineTableMetaData getTableMetaData(String schemaName, String tableName) {
        PipelineTableMetaData result = this.tableMetaDataMap.get(new TableName(tableName));
        if (null != result) {
            return result;
        }
        try {
            this.loadTableMetaData(schemaName, tableName);
        }
        catch (SQLException ex) {
            throw new RuntimeException(String.format("Load metadata for schema '%s' and table '%s' failed", schemaName, tableName), ex);
        }
        result = this.tableMetaDataMap.get(new TableName(tableName));
        if (null == result) {
            log.warn("getTableMetaData, can not load metadata for table '{}'", (Object)tableName);
        }
        return result;
    }

    private void loadTableMetaData(String schemaName, String tableNamePattern) throws SQLException {
        try (Connection connection = this.dataSource.getConnection();){
            long startMillis = System.currentTimeMillis();
            String schemaNameFinal = this.isSchemaAvailable() ? schemaName : null;
            Map<TableName, PipelineTableMetaData> tableMetaDataMap = this.loadTableMetaData0(connection, schemaNameFinal, tableNamePattern);
            log.info("loadTableMetaData, schemaNameFinal={}, tableNamePattern={}, result={}, cost time={} ms", new Object[]{schemaNameFinal, tableNamePattern, tableMetaDataMap, System.currentTimeMillis() - startMillis});
            this.tableMetaDataMap.putAll(tableMetaDataMap);
        }
    }

    private boolean isSchemaAvailable() {
        return DatabaseTypeFactory.getInstance((String)this.dataSource.getDatabaseType().getType()).isSchemaAvailable();
    }

    private Map<TableName, PipelineTableMetaData> loadTableMetaData0(Connection connection, String schemaName, String tableNamePattern) throws SQLException {
        ArrayList<String> tableNames = new ArrayList<String>();
        ResultSet resultSet = connection.getMetaData().getTables(connection.getCatalog(), schemaName, tableNamePattern, null);
        Object object = null;
        try {
            while (resultSet.next()) {
                String tableName = resultSet.getString("TABLE_NAME");
                tableNames.add(tableName);
            }
        }
        catch (Throwable tableName) {
            object = tableName;
            throw tableName;
        }
        finally {
            if (resultSet != null) {
                if (object != null) {
                    try {
                        resultSet.close();
                    }
                    catch (Throwable tableName) {
                        ((Throwable)object).addSuppressed(tableName);
                    }
                } else {
                    resultSet.close();
                }
            }
        }
        LinkedHashMap<TableName, PipelineTableMetaData> result = new LinkedHashMap<TableName, PipelineTableMetaData>();
        for (String each : tableNames) {
            Set<String> primaryKeys = this.loadPrimaryKeys(connection, schemaName, each);
            Map<String, Collection<String>> uniqueKeys = this.loadUniqueIndexesOfTable(connection, schemaName, each);
            LinkedHashMap<String, PipelineColumnMetaData> columnMetaDataMap = new LinkedHashMap<String, PipelineColumnMetaData>();
            try (ResultSet resultSet2 = connection.getMetaData().getColumns(connection.getCatalog(), schemaName, each, "%");){
                while (resultSet2.next()) {
                    int ordinalPosition = resultSet2.getInt("ORDINAL_POSITION");
                    String columnName = resultSet2.getString("COLUMN_NAME");
                    if (columnMetaDataMap.containsKey(columnName)) continue;
                    int dataType = resultSet2.getInt("DATA_TYPE");
                    String dataTypeName = resultSet2.getString("TYPE_NAME");
                    boolean primaryKey = primaryKeys.contains(columnName);
                    boolean isNullable = "YES".equals(resultSet2.getString("IS_NULLABLE"));
                    boolean isUniqueKey = primaryKey || uniqueKeys.values().stream().anyMatch(names -> names.contains(columnName));
                    PipelineColumnMetaData columnMetaData = new PipelineColumnMetaData(ordinalPosition, columnName, dataType, dataTypeName, isNullable, primaryKey, isUniqueKey);
                    columnMetaDataMap.put(columnName, columnMetaData);
                }
            }
            Collection uniqueIndexMetaData = uniqueKeys.entrySet().stream().map(e -> new PipelineIndexMetaData((String)e.getKey(), ((Collection)e.getValue()).stream().map(columnMetaDataMap::get).collect(Collectors.toList()))).collect(Collectors.toList());
            result.put(new TableName(each), new PipelineTableMetaData(each, columnMetaDataMap, uniqueIndexMetaData));
        }
        return result;
    }

    private Map<String, Collection<String>> loadUniqueIndexesOfTable(Connection connection, String schemaName, String tableName) throws SQLException {
        LinkedHashMap<String, SortedMap> orderedColumnsOfIndexes = new LinkedHashMap<String, SortedMap>();
        ResultSet resultSet = connection.getMetaData().getIndexInfo(connection.getCatalog(), schemaName, tableName, true, false);
        Object object = null;
        try {
            while (resultSet.next()) {
                String string = resultSet.getString("INDEX_NAME");
                if (null == string) continue;
                orderedColumnsOfIndexes.computeIfAbsent(string, unused -> new TreeMap()).put(resultSet.getShort("ORDINAL_POSITION"), resultSet.getString("COLUMN_NAME"));
            }
        }
        catch (Throwable throwable) {
            object = throwable;
            throw throwable;
        }
        finally {
            if (resultSet != null) {
                if (object != null) {
                    try {
                        resultSet.close();
                    }
                    catch (Throwable throwable) {
                        ((Throwable)object).addSuppressed(throwable);
                    }
                } else {
                    resultSet.close();
                }
            }
        }
        LinkedHashMap<String, Collection<String>> result = new LinkedHashMap<String, Collection<String>>();
        for (Map.Entry entry : orderedColumnsOfIndexes.entrySet()) {
            Collection columnNames = result.computeIfAbsent((String)entry.getKey(), (Function<String, Collection<String>>)((Function<String, Collection>)unused -> new LinkedList()));
            columnNames.addAll(((SortedMap)entry.getValue()).values());
        }
        return result;
    }

    private Set<String> loadPrimaryKeys(Connection connection, String schemaName, String tableName) throws SQLException {
        LinkedHashSet<String> result = new LinkedHashSet<String>();
        try (ResultSet resultSet = connection.getMetaData().getPrimaryKeys(connection.getCatalog(), schemaName, tableName);){
            while (resultSet.next()) {
                result.add(resultSet.getString("COLUMN_NAME"));
            }
        }
        return result;
    }

    @Generated
    public StandardPipelineTableMetaDataLoader(PipelineDataSourceWrapper dataSource) {
        this.dataSource = dataSource;
    }
}

