/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.data.pipeline.core.metadata.node;

import java.util.regex.Pattern;
import lombok.Generated;
import org.apache.shardingsphere.data.pipeline.api.job.JobType;

public final class PipelineMetaDataNode {
    private static final String JOB_PATTERN_PREFIX = "/pipeline/jobs/(j\\d{2}\\d{2}[0-9a-z]+)";
    public static final Pattern CONFIG_PATTERN = Pattern.compile("/pipeline/jobs/(j\\d{2}\\d{2}[0-9a-z]+)/config");
    public static final Pattern BARRIER_PATTERN = Pattern.compile("/pipeline/jobs/(j\\d{2}\\d{2}[0-9a-z]+)/barrier/(enable|disable)/\\d+");

    public static String getMetaDataDataSourcesPath(JobType jobType) {
        return String.join((CharSequence)"/", PipelineMetaDataNode.getMetaDataRootPath(jobType), "dataSources");
    }

    private static String getMetaDataRootPath(JobType jobType) {
        return null == jobType ? String.join((CharSequence)"/", "/pipeline", "metadata") : String.join((CharSequence)"/", "/pipeline", jobType.getLowercaseTypeName(), "metadata");
    }

    public static String getMetaDataProcessConfigPath(JobType jobType) {
        return String.join((CharSequence)"/", PipelineMetaDataNode.getMetaDataRootPath(jobType), "processConfig");
    }

    public static String getElasticJobNamespace() {
        return PipelineMetaDataNode.getJobsPath();
    }

    private static String getJobsPath() {
        return String.join((CharSequence)"/", "/pipeline", "jobs");
    }

    public static String getJobRootPath(String jobId) {
        return String.join((CharSequence)"/", PipelineMetaDataNode.getJobsPath(), jobId);
    }

    public static String getJobOffsetItemPath(String jobId, int shardingItem) {
        return String.join((CharSequence)"/", PipelineMetaDataNode.getJobOffsetPath(jobId), Integer.toString(shardingItem));
    }

    public static String getJobOffsetPath(String jobId) {
        return String.join((CharSequence)"/", PipelineMetaDataNode.getJobRootPath(jobId), "offset");
    }

    public static String getJobConfigPath(String jobId) {
        return String.join((CharSequence)"/", PipelineMetaDataNode.getJobRootPath(jobId), "config");
    }

    public static String getCheckLatestJobIdPath(String jobId) {
        return String.join((CharSequence)"/", PipelineMetaDataNode.getJobRootPath(jobId), "check", "latest_job_id");
    }

    public static String getCheckJobResultPath(String jobId, String checkJobId) {
        return String.join((CharSequence)"/", PipelineMetaDataNode.getCheckJobIdsRootPath(jobId), checkJobId);
    }

    public static String getCheckJobIdsRootPath(String jobId) {
        return String.join((CharSequence)"/", PipelineMetaDataNode.getJobRootPath(jobId), "check", "job_ids");
    }

    public static String getCheckJobIdPath(String jobId, String checkJobId) {
        return String.join((CharSequence)"/", PipelineMetaDataNode.getCheckJobIdsRootPath(jobId), checkJobId);
    }

    public static String getJobBarrierEnablePath(String jobId) {
        return String.join((CharSequence)"/", PipelineMetaDataNode.getJobRootPath(jobId), "barrier", "enable");
    }

    public static String getJobBarrierDisablePath(String jobId) {
        return String.join((CharSequence)"/", PipelineMetaDataNode.getJobRootPath(jobId), "barrier", "disable");
    }

    public static String getJobItemErrorMessagePath(String jobId, int shardingItem) {
        return String.join((CharSequence)"/", PipelineMetaDataNode.getJobRootPath(jobId), "error", Integer.toString(shardingItem));
    }

    @Generated
    private PipelineMetaDataNode() {
    }
}

