/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.data.pipeline.core.metadata.node;

import java.util.Collection;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Pattern;
import lombok.Generated;
import org.apache.shardingsphere.data.pipeline.core.api.PipelineAPIFactory;
import org.apache.shardingsphere.data.pipeline.core.metadata.node.event.handler.PipelineMetaDataChangedEventHandler;
import org.apache.shardingsphere.data.pipeline.core.metadata.node.event.handler.PipelineMetaDataChangedEventHandlerFactory;
import org.apache.shardingsphere.mode.repository.cluster.listener.DataChangedEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class PipelineMetaDataNodeWatcher {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(PipelineMetaDataNodeWatcher.class);
    private static final PipelineMetaDataNodeWatcher INSTANCE = new PipelineMetaDataNodeWatcher();
    private final Map<Pattern, PipelineMetaDataChangedEventHandler> listenerMap = new ConcurrentHashMap<Pattern, PipelineMetaDataChangedEventHandler>();

    private PipelineMetaDataNodeWatcher() {
        Collection<PipelineMetaDataChangedEventHandler> instances = PipelineMetaDataChangedEventHandlerFactory.findAllInstances();
        for (PipelineMetaDataChangedEventHandler each : instances) {
            this.listenerMap.put(each.getKeyPattern(), each);
        }
        PipelineAPIFactory.getGovernanceRepositoryAPI().watch("/pipeline", this::dispatchEvent);
    }

    private void dispatchEvent(DataChangedEvent event) {
        for (Map.Entry<Pattern, PipelineMetaDataChangedEventHandler> entry : this.listenerMap.entrySet()) {
            if (!entry.getKey().matcher(event.getKey()).matches()) continue;
            entry.getValue().handle(event);
            return;
        }
    }

    public static PipelineMetaDataNodeWatcher getInstance() {
        return INSTANCE;
    }
}

