/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.data.pipeline.core.metadata.node.event.handler.impl;

import java.util.regex.Pattern;
import lombok.Generated;
import org.apache.shardingsphere.data.pipeline.core.job.PipelineJobIdUtils;
import org.apache.shardingsphere.data.pipeline.core.metadata.node.PipelineMetaDataNode;
import org.apache.shardingsphere.data.pipeline.core.metadata.node.event.handler.PipelineChangedJobConfigurationProcessor;
import org.apache.shardingsphere.data.pipeline.core.metadata.node.event.handler.PipelineChangedJobConfigurationProcessorFactory;
import org.apache.shardingsphere.data.pipeline.core.metadata.node.event.handler.PipelineMetaDataChangedEventHandler;
import org.apache.shardingsphere.elasticjob.infra.pojo.JobConfigurationPOJO;
import org.apache.shardingsphere.infra.util.yaml.YamlEngine;
import org.apache.shardingsphere.mode.repository.cluster.listener.DataChangedEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ChangedJobConfigurationDispatcher
implements PipelineMetaDataChangedEventHandler {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ChangedJobConfigurationDispatcher.class);

    @Override
    public Pattern getKeyPattern() {
        return PipelineMetaDataNode.CONFIG_PATTERN;
    }

    @Override
    public void handle(DataChangedEvent event) {
        JobConfigurationPOJO jobConfigPOJO;
        try {
            jobConfigPOJO = (JobConfigurationPOJO)YamlEngine.unmarshal((String)event.getValue(), JobConfigurationPOJO.class, (boolean)true);
        }
        catch (Exception ex) {
            log.error("unmarshal job configuration pojo failed.", (Throwable)ex);
            return;
        }
        log.info("{} job configuration: {}, disabled={}", new Object[]{event.getType(), event.getKey(), jobConfigPOJO.isDisabled()});
        PipelineChangedJobConfigurationProcessor processor = PipelineChangedJobConfigurationProcessorFactory.getInstance(PipelineJobIdUtils.parseJobType(jobConfigPOJO.getJobName()));
        processor.process(event.getType(), jobConfigPOJO);
    }
}

