/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.data.pipeline.core.prepare;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import javax.sql.DataSource;
import lombok.Generated;
import org.apache.shardingsphere.data.pipeline.api.config.ImporterConfiguration;
import org.apache.shardingsphere.data.pipeline.api.config.ingest.DumperConfiguration;
import org.apache.shardingsphere.data.pipeline.api.config.ingest.InventoryDumperConfiguration;
import org.apache.shardingsphere.data.pipeline.api.config.job.PipelineJobConfiguration;
import org.apache.shardingsphere.data.pipeline.api.config.process.PipelineReadConfiguration;
import org.apache.shardingsphere.data.pipeline.api.datasource.PipelineDataSourceWrapper;
import org.apache.shardingsphere.data.pipeline.api.ingest.position.IngestPosition;
import org.apache.shardingsphere.data.pipeline.api.ingest.position.IntegerPrimaryKeyPosition;
import org.apache.shardingsphere.data.pipeline.api.ingest.position.PlaceholderPosition;
import org.apache.shardingsphere.data.pipeline.api.ingest.position.StringPrimaryKeyPosition;
import org.apache.shardingsphere.data.pipeline.api.job.JobStatus;
import org.apache.shardingsphere.data.pipeline.api.job.progress.InventoryIncrementalJobItemProgress;
import org.apache.shardingsphere.data.pipeline.api.metadata.LogicTableName;
import org.apache.shardingsphere.data.pipeline.api.metadata.model.PipelineColumnMetaData;
import org.apache.shardingsphere.data.pipeline.core.context.InventoryIncrementalJobItemContext;
import org.apache.shardingsphere.data.pipeline.core.context.InventoryIncrementalProcessContext;
import org.apache.shardingsphere.data.pipeline.core.exception.job.SplitPipelineJobByRangeException;
import org.apache.shardingsphere.data.pipeline.core.exception.job.SplitPipelineJobByUniqueKeyException;
import org.apache.shardingsphere.data.pipeline.core.metadata.loader.PipelineTableMetaDataUtil;
import org.apache.shardingsphere.data.pipeline.core.sqlbuilder.PipelineSQLBuilderFactory;
import org.apache.shardingsphere.data.pipeline.core.task.InventoryTask;
import org.apache.shardingsphere.data.pipeline.core.util.PipelineJdbcUtils;
import org.apache.shardingsphere.data.pipeline.spi.ingest.channel.PipelineChannelCreator;
import org.apache.shardingsphere.data.pipeline.spi.ratelimit.JobRateLimitAlgorithm;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class InventoryTaskSplitter {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(InventoryTaskSplitter.class);
    private final PipelineDataSourceWrapper sourceDataSource;
    private final InventoryDumperConfiguration dumperConfig;
    private final ImporterConfiguration importerConfig;

    public List<InventoryTask> splitInventoryData(InventoryIncrementalJobItemContext jobItemContext) {
        LinkedList<InventoryTask> result = new LinkedList<InventoryTask>();
        long startTimeMillis = System.currentTimeMillis();
        PipelineChannelCreator pipelineChannelCreator = jobItemContext.getJobProcessContext().getPipelineChannelCreator();
        for (InventoryDumperConfiguration each : this.splitDumperConfig(jobItemContext, this.dumperConfig)) {
            result.add(new InventoryTask(each, this.importerConfig, pipelineChannelCreator, jobItemContext.getDataSourceManager(), (DataSource)this.sourceDataSource, jobItemContext.getSourceMetaDataLoader(), jobItemContext.getJobProcessContext().getInventoryDumperExecuteEngine(), jobItemContext.getJobProcessContext().getInventoryImporterExecuteEngine(), jobItemContext));
        }
        log.info("splitInventoryData cost {} ms", (Object)(System.currentTimeMillis() - startTimeMillis));
        return result;
    }

    private Collection<InventoryDumperConfiguration> splitDumperConfig(InventoryIncrementalJobItemContext jobItemContext, InventoryDumperConfiguration dumperConfig) {
        LinkedList<InventoryDumperConfiguration> result = new LinkedList<InventoryDumperConfiguration>();
        for (InventoryDumperConfiguration each : this.splitByTable(dumperConfig)) {
            result.addAll(this.splitByPrimaryKey(each, jobItemContext, (DataSource)this.sourceDataSource));
        }
        return result;
    }

    private Collection<InventoryDumperConfiguration> splitByTable(InventoryDumperConfiguration dumperConfig) {
        LinkedList<InventoryDumperConfiguration> result = new LinkedList<InventoryDumperConfiguration>();
        dumperConfig.getTableNameMap().forEach((key, value) -> {
            InventoryDumperConfiguration inventoryDumperConfig = new InventoryDumperConfiguration((DumperConfiguration)dumperConfig);
            inventoryDumperConfig.setActualTableName(key.getOriginal());
            inventoryDumperConfig.setLogicTableName(value.getOriginal());
            inventoryDumperConfig.setPosition((IngestPosition)new PlaceholderPosition());
            inventoryDumperConfig.setUniqueKey(dumperConfig.getUniqueKey());
            inventoryDumperConfig.setUniqueKeyDataType(dumperConfig.getUniqueKeyDataType());
            result.add(inventoryDumperConfig);
        });
        return result;
    }

    private Collection<InventoryDumperConfiguration> splitByPrimaryKey(InventoryDumperConfiguration dumperConfig, InventoryIncrementalJobItemContext jobItemContext, DataSource dataSource) {
        if (null == dumperConfig.getUniqueKey()) {
            String schemaName = dumperConfig.getSchemaName(new LogicTableName(dumperConfig.getLogicTableName()));
            String actualTableName = dumperConfig.getActualTableName();
            PipelineColumnMetaData uniqueKeyColumn = PipelineTableMetaDataUtil.getUniqueKeyColumn(schemaName, actualTableName, jobItemContext.getSourceMetaDataLoader());
            dumperConfig.setUniqueKey(uniqueKeyColumn.getName());
            dumperConfig.setUniqueKeyDataType(Integer.valueOf(uniqueKeyColumn.getDataType()));
        }
        LinkedList<InventoryDumperConfiguration> result = new LinkedList<InventoryDumperConfiguration>();
        InventoryIncrementalProcessContext jobProcessContext = jobItemContext.getJobProcessContext();
        PipelineReadConfiguration readConfig = jobProcessContext.getPipelineProcessConfig().getRead();
        int batchSize = readConfig.getBatchSize();
        JobRateLimitAlgorithm rateLimitAlgorithm = jobProcessContext.getReadRateLimitAlgorithm();
        Collection<IngestPosition<?>> inventoryPositions = this.getInventoryPositions(jobItemContext, dumperConfig, dataSource);
        int i = 0;
        for (IngestPosition<?> inventoryPosition : inventoryPositions) {
            InventoryDumperConfiguration splitDumperConfig = new InventoryDumperConfiguration((DumperConfiguration)dumperConfig);
            splitDumperConfig.setPosition(inventoryPosition);
            splitDumperConfig.setShardingItem(Integer.valueOf(i++));
            splitDumperConfig.setActualTableName(dumperConfig.getActualTableName());
            splitDumperConfig.setLogicTableName(dumperConfig.getLogicTableName());
            splitDumperConfig.setUniqueKey(dumperConfig.getUniqueKey());
            splitDumperConfig.setUniqueKeyDataType(dumperConfig.getUniqueKeyDataType());
            splitDumperConfig.setBatchSize(batchSize);
            splitDumperConfig.setRateLimitAlgorithm(rateLimitAlgorithm);
            result.add(splitDumperConfig);
        }
        return result;
    }

    private Collection<IngestPosition<?>> getInventoryPositions(InventoryIncrementalJobItemContext jobItemContext, InventoryDumperConfiguration dumperConfig, DataSource dataSource) {
        InventoryIncrementalJobItemProgress initProgress = jobItemContext.getInitProgress();
        if (null != initProgress && initProgress.getStatus() != JobStatus.PREPARING_FAILURE) {
            return initProgress.getInventory().getInventoryPosition(dumperConfig.getActualTableName()).values();
        }
        int uniqueKeyDataType = dumperConfig.getUniqueKeyDataType();
        if (PipelineJdbcUtils.isIntegerColumn(uniqueKeyDataType)) {
            return this.getPositionByIntegerPrimaryKeyRange(jobItemContext, dataSource, dumperConfig);
        }
        if (PipelineJdbcUtils.isStringColumn(uniqueKeyDataType)) {
            return this.getPositionByStringPrimaryKeyRange();
        }
        throw new SplitPipelineJobByRangeException(dumperConfig.getActualTableName(), "primary key is not integer or string type");
    }

    private Collection<IngestPosition<?>> getPositionByIntegerPrimaryKeyRange(InventoryIncrementalJobItemContext jobItemContext, DataSource dataSource, InventoryDumperConfiguration dumperConfig) {
        LinkedList result = new LinkedList();
        PipelineJobConfiguration jobConfig = jobItemContext.getJobConfig();
        String sql = PipelineSQLBuilderFactory.getInstance(jobConfig.getSourceDatabaseType()).buildSplitByPrimaryKeyRangeSQL(dumperConfig.getSchemaName(new LogicTableName(dumperConfig.getLogicTableName())), dumperConfig.getActualTableName(), dumperConfig.getUniqueKey());
        int shardingSize = jobItemContext.getJobProcessContext().getPipelineProcessConfig().getRead().getShardingSize();
        try (Connection connection = dataSource.getConnection();
             PreparedStatement ps = connection.prepareStatement(sql);){
            long beginId = 0L;
            for (int i = 0; i < Integer.MAX_VALUE; ++i) {
                ps.setLong(1, beginId);
                ps.setLong(2, shardingSize);
                try (ResultSet rs = ps.executeQuery();){
                    if (!rs.next()) {
                        log.info("getPositionByPrimaryKeyRange, rs.next false, break");
                        break;
                    }
                    long endId = rs.getLong(1);
                    if (0L == endId) {
                        log.info("getPositionByPrimaryKeyRange, endId is 0, break, tableName={}, primaryKey={}, beginId={}", new Object[]{dumperConfig.getActualTableName(), dumperConfig.getUniqueKey(), beginId});
                        break;
                    }
                    result.add((IngestPosition<?>)new IntegerPrimaryKeyPosition(beginId, endId));
                    beginId = endId + 1L;
                    continue;
                }
            }
            if (result.isEmpty()) {
                result.add((IngestPosition<?>)new IntegerPrimaryKeyPosition(0L, 0L));
            }
        }
        catch (SQLException ex) {
            throw new SplitPipelineJobByUniqueKeyException(dumperConfig.getActualTableName(), dumperConfig.getUniqueKey(), ex);
        }
        return result;
    }

    private Collection<IngestPosition<?>> getPositionByStringPrimaryKeyRange() {
        LinkedList result = new LinkedList();
        result.add((IngestPosition<?>)new StringPrimaryKeyPosition("!", "~"));
        return result;
    }

    @Generated
    public InventoryTaskSplitter(PipelineDataSourceWrapper sourceDataSource, InventoryDumperConfiguration dumperConfig, ImporterConfiguration importerConfig) {
        this.sourceDataSource = sourceDataSource;
        this.dumperConfig = dumperConfig;
        this.importerConfig = importerConfig;
    }
}

