/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.data.pipeline.core.prepare;

import java.sql.SQLException;
import java.util.Collection;
import java.util.Optional;
import javax.sql.DataSource;
import lombok.Generated;
import org.apache.shardingsphere.data.pipeline.api.config.ImporterConfiguration;
import org.apache.shardingsphere.data.pipeline.api.config.ingest.DumperConfiguration;
import org.apache.shardingsphere.data.pipeline.api.datasource.PipelineDataSourceManager;
import org.apache.shardingsphere.data.pipeline.api.datasource.PipelineDataSourceWrapper;
import org.apache.shardingsphere.data.pipeline.api.datasource.config.PipelineDataSourceConfiguration;
import org.apache.shardingsphere.data.pipeline.api.datasource.config.impl.ShardingSpherePipelineDataSourceConfiguration;
import org.apache.shardingsphere.data.pipeline.api.datasource.config.impl.StandardPipelineDataSourceConfiguration;
import org.apache.shardingsphere.data.pipeline.api.ingest.position.IngestPosition;
import org.apache.shardingsphere.data.pipeline.api.job.progress.JobItemIncrementalTasksProgress;
import org.apache.shardingsphere.data.pipeline.core.check.datasource.DataSourceCheckerFactory;
import org.apache.shardingsphere.data.pipeline.core.context.PipelineContext;
import org.apache.shardingsphere.data.pipeline.core.prepare.datasource.DataSourcePreparer;
import org.apache.shardingsphere.data.pipeline.core.prepare.datasource.DataSourcePreparerFactory;
import org.apache.shardingsphere.data.pipeline.core.prepare.datasource.PrepareTargetSchemasParameter;
import org.apache.shardingsphere.data.pipeline.core.prepare.datasource.PrepareTargetTablesParameter;
import org.apache.shardingsphere.data.pipeline.spi.check.datasource.DataSourceChecker;
import org.apache.shardingsphere.data.pipeline.spi.ingest.dumper.IncrementalDumperCreatorFactory;
import org.apache.shardingsphere.data.pipeline.spi.ingest.position.PositionInitializer;
import org.apache.shardingsphere.data.pipeline.spi.ingest.position.PositionInitializerFactory;
import org.apache.shardingsphere.infra.database.type.DatabaseType;
import org.apache.shardingsphere.infra.datasource.pool.creator.DataSourcePoolCreator;
import org.apache.shardingsphere.infra.datasource.props.DataSourceProperties;
import org.apache.shardingsphere.infra.metadata.ShardingSphereMetaData;
import org.apache.shardingsphere.infra.metadata.database.ShardingSphereDatabase;
import org.apache.shardingsphere.infra.parser.ShardingSphereSQLParserEngine;
import org.apache.shardingsphere.infra.yaml.config.swapper.resource.YamlDataSourceConfigurationSwapper;
import org.apache.shardingsphere.parser.rule.SQLParserRule;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class PipelineJobPreparerUtils {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(PipelineJobPreparerUtils.class);

    public static boolean isIncrementalSupported(String databaseType) {
        return IncrementalDumperCreatorFactory.findInstance((String)databaseType).isPresent();
    }

    public static void prepareTargetSchema(String databaseType, PrepareTargetSchemasParameter prepareTargetSchemasParameter) throws SQLException {
        Optional<DataSourcePreparer> dataSourcePreparer = DataSourcePreparerFactory.getInstance(databaseType);
        if (!dataSourcePreparer.isPresent()) {
            log.info("dataSourcePreparer null, ignore prepare target");
            return;
        }
        long startTimeMillis = System.currentTimeMillis();
        dataSourcePreparer.get().prepareTargetSchemas(prepareTargetSchemasParameter);
        log.info("prepareTargetSchema cost {} ms", (Object)(System.currentTimeMillis() - startTimeMillis));
    }

    public static ShardingSphereSQLParserEngine getSQLParserEngine(String targetDatabaseName) {
        ShardingSphereMetaData metaData = PipelineContext.getContextManager().getMetaDataContexts().getMetaData();
        ShardingSphereDatabase database = (ShardingSphereDatabase)metaData.getDatabases().get(targetDatabaseName);
        return ((SQLParserRule)metaData.getGlobalRuleMetaData().getSingleRule(SQLParserRule.class)).getSQLParserEngine(database.getProtocolType().getType());
    }

    public static void prepareTargetTables(String databaseType, PrepareTargetTablesParameter prepareTargetTablesParameter) throws SQLException {
        Optional<DataSourcePreparer> dataSourcePreparer = DataSourcePreparerFactory.getInstance(databaseType);
        if (!dataSourcePreparer.isPresent()) {
            log.info("dataSourcePreparer null, ignore prepare target");
            return;
        }
        long startTimeMillis = System.currentTimeMillis();
        dataSourcePreparer.get().prepareTargetTables(prepareTargetTablesParameter);
        log.info("prepareTargetTables cost {} ms", (Object)(System.currentTimeMillis() - startTimeMillis));
    }

    public static IngestPosition<?> getIncrementalPosition(JobItemIncrementalTasksProgress initIncremental, DumperConfiguration dumperConfig, PipelineDataSourceManager dataSourceManager) throws SQLException {
        Optional position;
        if (null != initIncremental && (position = initIncremental.getIncrementalPosition()).isPresent()) {
            return (IngestPosition)position.get();
        }
        String databaseType = dumperConfig.getDataSourceConfig().getDatabaseType().getType();
        PipelineDataSourceWrapper dataSource = dataSourceManager.getDataSource(dumperConfig.getDataSourceConfig());
        long startTimeMillis = System.currentTimeMillis();
        IngestPosition result = PositionInitializerFactory.getInstance((String)databaseType).init((DataSource)dataSource, dumperConfig.getJobId());
        log.info("getIncrementalPosition cost {} ms", (Object)(System.currentTimeMillis() - startTimeMillis));
        return result;
    }

    public static void checkSourceDataSource(String databaseType, Collection<? extends DataSource> dataSources) {
        if (null == dataSources || dataSources.isEmpty()) {
            log.info("source data source is empty, skip check");
            return;
        }
        long startTimeMillis = System.currentTimeMillis();
        DataSourceChecker dataSourceChecker = DataSourceCheckerFactory.getInstance(databaseType);
        dataSourceChecker.checkConnection(dataSources);
        dataSourceChecker.checkPrivilege(dataSources);
        dataSourceChecker.checkVariable(dataSources);
        log.info("checkSourceDataSource cost {} ms", (Object)(System.currentTimeMillis() - startTimeMillis));
    }

    public static void checkTargetDataSource(String databaseType, ImporterConfiguration importerConfig, Collection<? extends DataSource> targetDataSources) {
        DataSourceChecker dataSourceChecker = DataSourceCheckerFactory.getInstance(databaseType);
        if (null == targetDataSources || targetDataSources.isEmpty()) {
            log.info("target data source is empty, skip check");
            return;
        }
        long startTimeMillis = System.currentTimeMillis();
        dataSourceChecker.checkConnection(targetDataSources);
        dataSourceChecker.checkTargetTable(targetDataSources, importerConfig.getTableNameSchemaNameMapping(), importerConfig.getLogicTableNames());
        log.info("checkTargetDataSource cost {} ms", (Object)(System.currentTimeMillis() - startTimeMillis));
    }

    public static void destroyPosition(String jobId, PipelineDataSourceConfiguration pipelineDataSourceConfig) throws SQLException {
        ShardingSpherePipelineDataSourceConfiguration dataSourceConfig;
        DatabaseType databaseType = pipelineDataSourceConfig.getDatabaseType();
        PositionInitializer positionInitializer = PositionInitializerFactory.getInstance((String)databaseType.getType());
        long startTimeMillis = System.currentTimeMillis();
        log.info("Cleanup database type:{}, data source type:{}", (Object)databaseType.getType(), (Object)pipelineDataSourceConfig.getType());
        if (pipelineDataSourceConfig instanceof ShardingSpherePipelineDataSourceConfiguration) {
            dataSourceConfig = (ShardingSpherePipelineDataSourceConfiguration)pipelineDataSourceConfig;
            for (DataSourceProperties each : new YamlDataSourceConfigurationSwapper().getDataSourcePropertiesMap(dataSourceConfig.getRootConfig()).values()) {
                PipelineDataSourceWrapper dataSource = new PipelineDataSourceWrapper(DataSourcePoolCreator.create((DataSourceProperties)each), databaseType);
                Throwable throwable = null;
                try {
                    positionInitializer.destroy((DataSource)dataSource, jobId);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (dataSource == null) continue;
                    if (throwable != null) {
                        try {
                            dataSource.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    dataSource.close();
                }
            }
        }
        if (pipelineDataSourceConfig instanceof StandardPipelineDataSourceConfiguration) {
            dataSourceConfig = (StandardPipelineDataSourceConfiguration)pipelineDataSourceConfig;
            try (PipelineDataSourceWrapper dataSource = new PipelineDataSourceWrapper(DataSourcePoolCreator.create((DataSourceProperties)((DataSourceProperties)dataSourceConfig.getDataSourceConfiguration())), databaseType);){
                positionInitializer.destroy((DataSource)dataSource, jobId);
            }
        }
        log.info("destroyPosition cost {} ms", (Object)(System.currentTimeMillis() - startTimeMillis));
    }
}

