/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.data.pipeline.core.prepare.datasource;

import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashSet;
import java.util.Optional;
import java.util.regex.Pattern;
import javax.sql.DataSource;
import lombok.Generated;
import org.apache.shardingsphere.data.pipeline.api.config.CreateTableConfiguration;
import org.apache.shardingsphere.data.pipeline.api.datasource.PipelineDataSourceManager;
import org.apache.shardingsphere.data.pipeline.api.datasource.PipelineDataSourceWrapper;
import org.apache.shardingsphere.data.pipeline.api.datasource.config.PipelineDataSourceConfiguration;
import org.apache.shardingsphere.data.pipeline.core.metadata.generator.PipelineDDLGenerator;
import org.apache.shardingsphere.data.pipeline.core.prepare.datasource.DataSourcePreparer;
import org.apache.shardingsphere.data.pipeline.core.prepare.datasource.PrepareTargetSchemasParameter;
import org.apache.shardingsphere.data.pipeline.core.sqlbuilder.PipelineSQLBuilderFactory;
import org.apache.shardingsphere.data.pipeline.spi.sqlbuilder.PipelineSQLBuilder;
import org.apache.shardingsphere.infra.database.type.DatabaseType;
import org.apache.shardingsphere.infra.database.type.DatabaseTypeEngine;
import org.apache.shardingsphere.infra.parser.ShardingSphereSQLParserEngine;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractDataSourcePreparer
implements DataSourcePreparer {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AbstractDataSourcePreparer.class);
    private static final Pattern PATTERN_CREATE_TABLE_IF_NOT_EXISTS = Pattern.compile("CREATE\\s+TABLE\\s+IF\\s+NOT\\s+EXISTS\\s+", 2);
    private static final Pattern PATTERN_CREATE_TABLE = Pattern.compile("CREATE\\s+TABLE\\s+", 2);
    private static final String[] IGNORE_EXCEPTION_MESSAGE = new String[]{"multiple primary keys for table", "already exists"};

    @Override
    public void prepareTargetSchemas(PrepareTargetSchemasParameter parameter) {
        DatabaseType targetDatabaseType = parameter.getTargetDatabaseType();
        if (!targetDatabaseType.isSchemaAvailable()) {
            log.info("prepareTargetSchemas, target database does not support schema, ignore, targetDatabaseType={}", (Object)targetDatabaseType);
            return;
        }
        CreateTableConfiguration createTableConfig = parameter.getCreateTableConfig();
        String defaultSchema = DatabaseTypeEngine.getDefaultSchemaName((DatabaseType)targetDatabaseType).orElse(null);
        PipelineSQLBuilder sqlBuilder = PipelineSQLBuilderFactory.getInstance(targetDatabaseType.getType());
        HashSet<String> createdSchemaNames = new HashSet<String>();
        for (CreateTableConfiguration.CreateTableEntry each : createTableConfig.getCreateTableEntries()) {
            Optional sql;
            String targetSchemaName = each.getTargetName().getSchemaName().getOriginal();
            if (null == targetSchemaName || targetSchemaName.equalsIgnoreCase(defaultSchema) || createdSchemaNames.contains(targetSchemaName) || !(sql = sqlBuilder.buildCreateSchemaSQL(targetSchemaName)).isPresent()) continue;
            this.executeCreateSchema(parameter.getDataSourceManager(), each.getTargetDataSourceConfig(), (String)sql.get());
            createdSchemaNames.add(targetSchemaName);
        }
        log.info("prepareTargetSchemas, createdSchemaNames={}, defaultSchema={}", createdSchemaNames, (Object)defaultSchema);
    }

    private void executeCreateSchema(PipelineDataSourceManager dataSourceManager, PipelineDataSourceConfiguration targetDataSourceConfig, String sql) {
        log.info("prepareTargetSchemas, sql={}", (Object)sql);
        try (Connection connection = this.getCachedDataSource(dataSourceManager, targetDataSourceConfig).getConnection();
             Statement statement = connection.createStatement();){
            statement.execute(sql);
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    protected final PipelineDataSourceWrapper getCachedDataSource(PipelineDataSourceManager dataSourceManager, PipelineDataSourceConfiguration dataSourceConfig) {
        return dataSourceManager.getDataSource(dataSourceConfig);
    }

    protected final void executeTargetTableSQL(Connection targetConnection, String sql) throws SQLException {
        log.info("execute target table sql: {}", (Object)sql);
        try (Statement statement = targetConnection.createStatement();){
            statement.execute(sql);
        }
        catch (SQLException ex) {
            log.warn("execute target table sql failed", (Throwable)ex);
            for (String ignoreMessage : IGNORE_EXCEPTION_MESSAGE) {
                if (!ex.getMessage().contains(ignoreMessage)) continue;
                return;
            }
            throw ex;
        }
    }

    protected final String addIfNotExistsForCreateTableSQL(String createTableSQL) {
        if (PATTERN_CREATE_TABLE_IF_NOT_EXISTS.matcher(createTableSQL).find()) {
            return createTableSQL;
        }
        return PATTERN_CREATE_TABLE.matcher(createTableSQL).replaceFirst("CREATE TABLE IF NOT EXISTS ");
    }

    protected final String getCreateTargetTableSQL(CreateTableConfiguration.CreateTableEntry createTableEntry, PipelineDataSourceManager dataSourceManager, ShardingSphereSQLParserEngine sqlParserEngine) throws SQLException {
        DatabaseType databaseType = createTableEntry.getSourceDataSourceConfig().getDatabaseType();
        PipelineDataSourceWrapper sourceDataSource = dataSourceManager.getDataSource(createTableEntry.getSourceDataSourceConfig());
        String schemaName = createTableEntry.getSourceName().getSchemaName().getOriginal();
        String sourceTableName = createTableEntry.getSourceName().getTableName().getOriginal();
        String targetTableName = createTableEntry.getTargetName().getTableName().getOriginal();
        PipelineDDLGenerator generator = new PipelineDDLGenerator();
        return generator.generateLogicDDL(databaseType, (DataSource)sourceDataSource, schemaName, sourceTableName, targetTableName, sqlParserEngine);
    }
}

