/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.data.pipeline.core.sqlbuilder;

import java.util.Map;
import java.util.Set;
import lombok.NonNull;
import org.apache.shardingsphere.data.pipeline.api.ingest.record.DataRecord;
import org.apache.shardingsphere.data.pipeline.api.metadata.LogicTableName;
import org.apache.shardingsphere.data.pipeline.core.sqlbuilder.AbstractPipelineSQLBuilder;

public final class OraclePipelineSQLBuilder
extends AbstractPipelineSQLBuilder {
    @Override
    public String buildDivisibleInventoryDumpSQL(String schemaName, String tableName, String uniqueKey, int uniqueKeyDataType, boolean firstQuery) {
        String qualifiedTableName = this.getQualifiedTableName(schemaName, tableName);
        String quotedUniqueKey = this.quote(uniqueKey);
        return String.format("SELECT * FROM (SELECT * FROM %s WHERE %s%s? AND %s<=? ORDER BY %s ASC) WHERE ROWNUM<=?", qualifiedTableName, quotedUniqueKey, firstQuery ? ">=" : ">", quotedUniqueKey, quotedUniqueKey);
    }

    @Override
    public String buildIndivisibleInventoryDumpSQL(String schemaName, String tableName, String uniqueKey, int uniqueKeyDataType, boolean firstQuery) {
        String qualifiedTableName = this.getQualifiedTableName(schemaName, tableName);
        String quotedUniqueKey = this.quote(uniqueKey);
        return String.format("SELECT * FROM (SELECT * FROM %s WHERE %s%s? ORDER BY %s ASC) WHERE ROWNUM<=?", qualifiedTableName, quotedUniqueKey, firstQuery ? ">=" : ">", quotedUniqueKey);
    }

    @Override
    public String buildInsertSQL(String schemaName, DataRecord dataRecord, Map<LogicTableName, Set<String>> shardingColumnsMap) {
        return super.buildInsertSQL(schemaName, dataRecord, shardingColumnsMap);
    }

    @Override
    public String buildChunkedQuerySQL(String schemaName, @NonNull String tableName, @NonNull String uniqueKey, boolean firstQuery) {
        if (tableName == null) {
            throw new NullPointerException("tableName is marked non-null but is null");
        }
        if (uniqueKey == null) {
            throw new NullPointerException("uniqueKey is marked non-null but is null");
        }
        String qualifiedTableName = this.getQualifiedTableName(schemaName, tableName);
        String quotedUniqueKey = this.quote(uniqueKey);
        return firstQuery ? String.format("SELECT * FROM (SELECT * FROM %s ORDER BY %s ASC) WHERE ROWNUM<=?", qualifiedTableName, quotedUniqueKey) : String.format("SELECT * FROM (SELECT * FROM %s WHERE %s>? ORDER BY %s ASC) WHERE ROWNUM<=?", qualifiedTableName, quotedUniqueKey, quotedUniqueKey);
    }

    @Override
    public String buildCheckEmptySQL(String schemaName, String tableName) {
        return String.format("SELECT * FROM (SELECT * FROM %s) WHERE ROWNUM<=1", this.getQualifiedTableName(schemaName, tableName));
    }

    @Override
    public String buildSplitByPrimaryKeyRangeSQL(String schemaName, String tableName, String primaryKey) {
        String qualifiedTableName = this.getQualifiedTableName(schemaName, tableName);
        String quotedUniqueKey = this.quote(primaryKey);
        return String.format("SELECT MAX(%s) FROM (SELECT * FROM (SELECT %s FROM %s WHERE %s>=? ORDER BY %s) WHERE ROWNUM<=?) t", quotedUniqueKey, quotedUniqueKey, qualifiedTableName, quotedUniqueKey, quotedUniqueKey);
    }

    public String getType() {
        return "Oracle";
    }
}

