/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.data.pipeline.scenario.consistencycheck;

import java.util.concurrent.CompletableFuture;
import lombok.Generated;
import org.apache.shardingsphere.data.pipeline.api.job.JobType;
import org.apache.shardingsphere.data.pipeline.core.api.PipelineAPIFactory;
import org.apache.shardingsphere.data.pipeline.core.context.PipelineContext;
import org.apache.shardingsphere.data.pipeline.core.job.PipelineJobCenter;
import org.apache.shardingsphere.data.pipeline.core.metadata.node.event.handler.PipelineChangedJobConfigurationProcessor;
import org.apache.shardingsphere.data.pipeline.scenario.consistencycheck.ConsistencyCheckJob;
import org.apache.shardingsphere.elasticjob.api.ElasticJob;
import org.apache.shardingsphere.elasticjob.infra.pojo.JobConfigurationPOJO;
import org.apache.shardingsphere.elasticjob.lite.api.bootstrap.JobBootstrap;
import org.apache.shardingsphere.elasticjob.lite.api.bootstrap.impl.OneOffJobBootstrap;
import org.apache.shardingsphere.mode.repository.cluster.listener.DataChangedEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ConsistencyCheckChangedJobConfigurationProcessor
implements PipelineChangedJobConfigurationProcessor {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ConsistencyCheckChangedJobConfigurationProcessor.class);

    @Override
    public void process(DataChangedEvent.Type eventType, JobConfigurationPOJO jobConfigPOJO) {
        String jobId = jobConfigPOJO.getJobName();
        if (jobConfigPOJO.isDisabled()) {
            log.info("{} is disabled", (Object)jobId);
            PipelineJobCenter.stop(jobId);
            return;
        }
        switch (eventType) {
            case ADDED: 
            case UPDATED: {
                if (PipelineJobCenter.isJobExisting(jobId)) {
                    log.info("{} added to executing jobs failed since it already exists", (Object)jobId);
                    break;
                }
                log.info("{} executing jobs", (Object)jobId);
                CompletableFuture.runAsync(() -> this.execute(jobConfigPOJO), PipelineContext.getEventListenerExecutor()).whenComplete((unused, throwable) -> {
                    if (null != throwable) {
                        log.error("execute failed, jobId={}", (Object)jobId, throwable);
                    }
                });
                break;
            }
            case DELETED: {
                log.info("deleted consistency check job id: {}", (Object)jobId);
                PipelineJobCenter.stop(jobId);
                break;
            }
        }
    }

    private void execute(JobConfigurationPOJO jobConfigPOJO) {
        ConsistencyCheckJob job = new ConsistencyCheckJob();
        PipelineJobCenter.addJob(jobConfigPOJO.getJobName(), job);
        OneOffJobBootstrap oneOffJobBootstrap = new OneOffJobBootstrap(PipelineAPIFactory.getRegistryCenter(), (ElasticJob)job, jobConfigPOJO.toJobConfiguration());
        job.setJobBootstrap((JobBootstrap)oneOffJobBootstrap);
        oneOffJobBootstrap.execute();
    }

    public String getType() {
        return JobType.CONSISTENCY_CHECK.getTypeName();
    }
}

