/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.data.pipeline.scenario.consistencycheck;

import lombok.Generated;
import org.apache.shardingsphere.data.pipeline.api.config.job.ConsistencyCheckJobConfiguration;
import org.apache.shardingsphere.data.pipeline.api.job.JobStatus;
import org.apache.shardingsphere.data.pipeline.api.job.PipelineJob;
import org.apache.shardingsphere.data.pipeline.api.task.PipelineTasksRunner;
import org.apache.shardingsphere.data.pipeline.core.job.AbstractPipelineJob;
import org.apache.shardingsphere.data.pipeline.core.job.progress.persist.PipelineJobProgressPersistService;
import org.apache.shardingsphere.data.pipeline.core.metadata.node.PipelineMetaDataNode;
import org.apache.shardingsphere.data.pipeline.core.util.PipelineDistributedBarrier;
import org.apache.shardingsphere.data.pipeline.scenario.consistencycheck.ConsistencyCheckJobAPI;
import org.apache.shardingsphere.data.pipeline.scenario.consistencycheck.ConsistencyCheckJobAPIFactory;
import org.apache.shardingsphere.data.pipeline.scenario.consistencycheck.ConsistencyCheckJobItemContext;
import org.apache.shardingsphere.data.pipeline.scenario.consistencycheck.ConsistencyCheckTasksRunner;
import org.apache.shardingsphere.data.pipeline.yaml.job.YamlConsistencyCheckJobConfigurationSwapper;
import org.apache.shardingsphere.elasticjob.api.ShardingContext;
import org.apache.shardingsphere.elasticjob.simple.job.SimpleJob;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ConsistencyCheckJob
extends AbstractPipelineJob
implements SimpleJob,
PipelineJob {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ConsistencyCheckJob.class);
    private final ConsistencyCheckJobAPI jobAPI = ConsistencyCheckJobAPIFactory.getInstance();
    private final PipelineDistributedBarrier pipelineDistributedBarrier = PipelineDistributedBarrier.getInstance();

    public void execute(ShardingContext shardingContext) {
        String checkJobId = shardingContext.getJobName();
        int shardingItem = shardingContext.getShardingItem();
        log.info("Execute job {}-{}", (Object)checkJobId, (Object)shardingItem);
        if (this.isStopping()) {
            log.info("stopping true, ignore");
            return;
        }
        this.setJobId(checkJobId);
        ConsistencyCheckJobConfiguration jobConfig = new YamlConsistencyCheckJobConfigurationSwapper().swapToObject(shardingContext.getJobParameter());
        ConsistencyCheckJobItemContext jobItemContext = new ConsistencyCheckJobItemContext(jobConfig, shardingItem, JobStatus.RUNNING);
        if (this.getTasksRunnerMap().containsKey(shardingItem)) {
            log.warn("tasksRunnerMap contains shardingItem {}, ignore", (Object)shardingItem);
            return;
        }
        log.info("start tasks runner, jobId={}, shardingItem={}", (Object)this.getJobId(), (Object)shardingItem);
        this.jobAPI.cleanJobItemErrorMessage(jobItemContext.getJobId(), jobItemContext.getShardingItem());
        ConsistencyCheckTasksRunner tasksRunner = new ConsistencyCheckTasksRunner(jobItemContext);
        tasksRunner.start();
        PipelineJobProgressPersistService.addJobProgressPersistContext(checkJobId, shardingContext.getShardingItem());
        this.getTasksRunnerMap().put(shardingItem, tasksRunner);
    }

    public void stop() {
        this.setStopping(true);
        if (null != this.getJobBootstrap()) {
            this.getJobBootstrap().shutdown();
        }
        if (null == this.getJobId()) {
            log.info("stop consistency check job, jobId is null, ignore");
            return;
        }
        for (PipelineTasksRunner each : this.getTasksRunnerMap().values()) {
            each.stop();
        }
        this.getTasksRunnerMap().clear();
        String jobBarrierDisablePath = PipelineMetaDataNode.getJobBarrierDisablePath(this.getJobId());
        this.pipelineDistributedBarrier.persistEphemeralChildrenNode(jobBarrierDisablePath, 0);
        PipelineJobProgressPersistService.removeJobProgressPersistContext(this.getJobId());
    }
}

