/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.data.pipeline.scenario.consistencycheck;

import com.google.common.base.Strings;
import java.sql.Timestamp;
import java.time.Duration;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import lombok.Generated;
import org.apache.shardingsphere.data.pipeline.api.check.consistency.DataConsistencyCheckResult;
import org.apache.shardingsphere.data.pipeline.api.config.PipelineTaskConfiguration;
import org.apache.shardingsphere.data.pipeline.api.config.job.ConsistencyCheckJobConfiguration;
import org.apache.shardingsphere.data.pipeline.api.config.job.PipelineJobConfiguration;
import org.apache.shardingsphere.data.pipeline.api.config.job.yaml.YamlPipelineJobConfiguration;
import org.apache.shardingsphere.data.pipeline.api.config.process.PipelineProcessConfiguration;
import org.apache.shardingsphere.data.pipeline.api.context.PipelineJobItemContext;
import org.apache.shardingsphere.data.pipeline.api.context.PipelineProcessContext;
import org.apache.shardingsphere.data.pipeline.api.job.JobStatus;
import org.apache.shardingsphere.data.pipeline.api.job.JobType;
import org.apache.shardingsphere.data.pipeline.api.job.PipelineJobId;
import org.apache.shardingsphere.data.pipeline.api.job.progress.ConsistencyCheckJobProgress;
import org.apache.shardingsphere.data.pipeline.api.pojo.ConsistencyCheckJobProgressInfo;
import org.apache.shardingsphere.data.pipeline.api.pojo.CreateConsistencyCheckJobParameter;
import org.apache.shardingsphere.data.pipeline.api.pojo.PipelineJobInfo;
import org.apache.shardingsphere.data.pipeline.core.api.GovernanceRepositoryAPI;
import org.apache.shardingsphere.data.pipeline.core.api.InventoryIncrementalJobAPI;
import org.apache.shardingsphere.data.pipeline.core.api.PipelineAPIFactory;
import org.apache.shardingsphere.data.pipeline.core.api.impl.AbstractPipelineJobAPIImpl;
import org.apache.shardingsphere.data.pipeline.core.exception.job.PipelineJobNotFoundException;
import org.apache.shardingsphere.data.pipeline.core.exception.job.UncompletedConsistencyCheckJobExistsException;
import org.apache.shardingsphere.data.pipeline.core.job.PipelineJobIdUtils;
import org.apache.shardingsphere.data.pipeline.core.job.progress.yaml.YamlConsistencyCheckJobProgress;
import org.apache.shardingsphere.data.pipeline.core.job.progress.yaml.YamlConsistencyCheckJobProgressSwapper;
import org.apache.shardingsphere.data.pipeline.scenario.consistencycheck.ConsistencyCheckJob;
import org.apache.shardingsphere.data.pipeline.scenario.consistencycheck.ConsistencyCheckJobAPI;
import org.apache.shardingsphere.data.pipeline.scenario.consistencycheck.ConsistencyCheckJobId;
import org.apache.shardingsphere.data.pipeline.scenario.consistencycheck.ConsistencyCheckJobItemContext;
import org.apache.shardingsphere.data.pipeline.yaml.job.YamlConsistencyCheckJobConfiguration;
import org.apache.shardingsphere.data.pipeline.yaml.job.YamlConsistencyCheckJobConfigurationSwapper;
import org.apache.shardingsphere.elasticjob.infra.pojo.JobConfigurationPOJO;
import org.apache.shardingsphere.infra.util.exception.ShardingSpherePreconditions;
import org.apache.shardingsphere.infra.util.yaml.YamlEngine;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ConsistencyCheckJobAPIImpl
extends AbstractPipelineJobAPIImpl
implements ConsistencyCheckJobAPI {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ConsistencyCheckJobAPIImpl.class);
    private static final DateTimeFormatter DATE_TIME_FORMATTER = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss.SSS");
    private final YamlConsistencyCheckJobProgressSwapper swapper = new YamlConsistencyCheckJobProgressSwapper();

    @Override
    protected String marshalJobIdLeftPart(PipelineJobId pipelineJobId) {
        ConsistencyCheckJobId jobId = (ConsistencyCheckJobId)pipelineJobId;
        return jobId.getParentJobId() + jobId.getSequence();
    }

    public String createJobAndStart(CreateConsistencyCheckJobParameter parameter) {
        ConsistencyCheckJobProgress progress;
        String parentJobId;
        GovernanceRepositoryAPI repositoryAPI = PipelineAPIFactory.getGovernanceRepositoryAPI();
        Optional<String> checkLatestJobId = repositoryAPI.getCheckLatestJobId(parentJobId = parameter.getJobId());
        if (checkLatestJobId.isPresent() && (null == (progress = this.getJobItemProgress(checkLatestJobId.get(), 0)) || JobStatus.FINISHED != progress.getStatus())) {
            log.info("check job already exists and status is not FINISHED, progress={}", (Object)progress);
            throw new UncompletedConsistencyCheckJobExistsException(checkLatestJobId.get());
        }
        int sequence = checkLatestJobId.map(optional -> ConsistencyCheckJobId.parseSequence(optional) + 1).orElse(1);
        String result = this.marshalJobId(new ConsistencyCheckJobId(parentJobId, sequence));
        repositoryAPI.persistCheckLatestJobId(parentJobId, result);
        repositoryAPI.deleteCheckJobResult(parentJobId, result);
        this.dropJob(result);
        YamlConsistencyCheckJobConfiguration yamlConfig = new YamlConsistencyCheckJobConfiguration();
        yamlConfig.setJobId(result);
        yamlConfig.setParentJobId(parentJobId);
        yamlConfig.setAlgorithmTypeName(parameter.getAlgorithmTypeName());
        yamlConfig.setAlgorithmProps(parameter.getAlgorithmProps());
        this.start((PipelineJobConfiguration)new YamlConsistencyCheckJobConfigurationSwapper().swapToObject(yamlConfig));
        return result;
    }

    public Map<String, DataConsistencyCheckResult> getLatestDataConsistencyCheckResult(String jobId) {
        Optional<String> checkLatestJobId = PipelineAPIFactory.getGovernanceRepositoryAPI().getCheckLatestJobId(jobId);
        if (!checkLatestJobId.isPresent()) {
            return Collections.emptyMap();
        }
        return PipelineAPIFactory.getGovernanceRepositoryAPI().getCheckJobResult(jobId, checkLatestJobId.get());
    }

    @Override
    public void persistJobItemProgress(PipelineJobItemContext jobItemContext) {
        ConsistencyCheckJobItemContext checkJobItemContext = (ConsistencyCheckJobItemContext)jobItemContext;
        ConsistencyCheckJobProgress jobProgress = new ConsistencyCheckJobProgress();
        jobProgress.setStatus(jobItemContext.getStatus());
        jobProgress.setCheckedRecordsCount(Long.valueOf(checkJobItemContext.getCheckedRecordsCount().get()));
        jobProgress.setRecordsCount(checkJobItemContext.getRecordsCount());
        jobProgress.setCheckBeginTimeMillis(Long.valueOf(checkJobItemContext.getCheckBeginTimeMillis()));
        jobProgress.setCheckEndTimeMillis(checkJobItemContext.getCheckEndTimeMillis());
        jobProgress.setTableNames(null == checkJobItemContext.getTableNames() ? null : String.join((CharSequence)",", checkJobItemContext.getTableNames()));
        YamlConsistencyCheckJobProgress yamlJobProgress = this.swapper.swapToYamlConfiguration(jobProgress);
        PipelineAPIFactory.getGovernanceRepositoryAPI().persistJobItemProgress(jobItemContext.getJobId(), jobItemContext.getShardingItem(), YamlEngine.marshal((Object)yamlJobProgress));
    }

    public ConsistencyCheckJobProgress getJobItemProgress(String jobId, int shardingItem) {
        String progress = PipelineAPIFactory.getGovernanceRepositoryAPI().getJobItemProgress(jobId, shardingItem);
        return Strings.isNullOrEmpty((String)progress) ? null : this.swapper.swapToObject((YamlConsistencyCheckJobProgress)YamlEngine.unmarshal((String)progress, YamlConsistencyCheckJobProgress.class, (boolean)true));
    }

    @Override
    public void updateJobItemStatus(String jobId, int shardingItem, JobStatus status) {
        ConsistencyCheckJobProgress jobProgress = this.getJobItemProgress(jobId, shardingItem);
        if (null == jobProgress) {
            log.warn("updateJobItemStatus, jobProgress is null, jobId={}, shardingItem={}", (Object)jobId, (Object)shardingItem);
            return;
        }
        jobProgress.setStatus(status);
        PipelineAPIFactory.getGovernanceRepositoryAPI().persistJobItemProgress(jobId, shardingItem, YamlEngine.marshal((Object)this.swapper.swapToYamlConfiguration(jobProgress)));
    }

    @Override
    public void startDisabledJob(String jobId) {
        log.info("Start disable check job {}", (Object)jobId);
        ConsistencyCheckJobProgress jobProgress = this.getJobItemProgress(jobId, 0);
        if (null != jobProgress && JobStatus.FINISHED == jobProgress.getStatus()) {
            log.info("job status is FINISHED, ignore, jobId={}", (Object)jobId);
            return;
        }
        super.startDisabledJob(jobId);
    }

    public void startByParentJobId(String parentJobId) {
        log.info("Start check job by parent job id: {}", (Object)parentJobId);
        Optional<String> checkLatestJobId = PipelineAPIFactory.getGovernanceRepositoryAPI().getCheckLatestJobId(parentJobId);
        ShardingSpherePreconditions.checkState((boolean)checkLatestJobId.isPresent(), () -> new PipelineJobNotFoundException(parentJobId));
        this.startDisabledJob(checkLatestJobId.get());
    }

    public void stopByParentJobId(String parentJobId) {
        log.info("Stop check job by parent job id: {}", (Object)parentJobId);
        Optional<String> checkLatestJobId = PipelineAPIFactory.getGovernanceRepositoryAPI().getCheckLatestJobId(parentJobId);
        ShardingSpherePreconditions.checkState((boolean)checkLatestJobId.isPresent(), () -> new PipelineJobNotFoundException(parentJobId));
        this.stop(checkLatestJobId.get());
    }

    public ConsistencyCheckJobProgressInfo getJobProgressInfo(String parentJobId) {
        Optional<String> checkLatestJobId = PipelineAPIFactory.getGovernanceRepositoryAPI().getCheckLatestJobId(parentJobId);
        ShardingSpherePreconditions.checkState((boolean)checkLatestJobId.isPresent(), () -> new PipelineJobNotFoundException(parentJobId));
        String checkJobId = checkLatestJobId.get();
        ConsistencyCheckJobProgress jobItemProgress = this.getJobItemProgress(checkJobId, 0);
        ConsistencyCheckJobProgressInfo result = new ConsistencyCheckJobProgressInfo();
        if (null == jobItemProgress) {
            return result;
        }
        LocalDateTime checkBeginTime = new Timestamp(jobItemProgress.getCheckBeginTimeMillis()).toLocalDateTime();
        if (null == jobItemProgress.getRecordsCount()) {
            result.setFinishedPercentage(0);
            result.setCheckSuccess(Boolean.valueOf(false));
            return result;
        }
        long recordsCount = jobItemProgress.getRecordsCount();
        if (JobStatus.FINISHED == jobItemProgress.getStatus()) {
            result.setFinishedPercentage(100);
            LocalDateTime checkEndTime = new Timestamp(jobItemProgress.getCheckEndTimeMillis()).toLocalDateTime();
            Duration duration = Duration.between(checkBeginTime, checkEndTime);
            result.setDurationSeconds(Long.valueOf(duration.getSeconds()));
            result.setCheckEndTime(DATE_TIME_FORMATTER.format(checkEndTime));
            result.setRemainingSeconds(Long.valueOf(0L));
        } else {
            long checkedRecordsCount = Math.min(jobItemProgress.getCheckedRecordsCount(), recordsCount);
            result.setFinishedPercentage((int)(checkedRecordsCount * 100L / recordsCount));
            JobConfigurationPOJO jobConfigPOJO = this.getElasticJobConfigPOJO(checkJobId);
            Long stopTimeMillis = jobConfigPOJO.isDisabled() ? Long.valueOf(Long.parseLong(jobConfigPOJO.getProps().getProperty("stop_time_millis"))) : null;
            long durationMillis = (null != stopTimeMillis ? stopTimeMillis : System.currentTimeMillis()) - jobItemProgress.getCheckBeginTimeMillis();
            result.setDurationSeconds(Long.valueOf(TimeUnit.MILLISECONDS.toSeconds(durationMillis)));
            if (null != stopTimeMillis) {
                result.setCheckEndTime(DATE_TIME_FORMATTER.format(new Timestamp(stopTimeMillis).toLocalDateTime()));
            }
            long remainingMills = (long)((double)(recordsCount - checkedRecordsCount) * 1.0 / (double)checkedRecordsCount * (double)durationMillis);
            result.setRemainingSeconds(Long.valueOf(remainingMills / 1000L));
        }
        String tableNames = jobItemProgress.getTableNames();
        result.setTableNames(Optional.ofNullable(tableNames).orElse(""));
        result.setCheckBeginTime(DATE_TIME_FORMATTER.format(checkBeginTime));
        result.setErrorMessage(this.getJobItemErrorMessage(checkJobId, 0));
        Map<String, DataConsistencyCheckResult> checkJobResult = PipelineAPIFactory.getGovernanceRepositoryAPI().getCheckJobResult(parentJobId, checkJobId);
        InventoryIncrementalJobAPI inventoryIncrementalJobAPI = (InventoryIncrementalJobAPI)PipelineAPIFactory.getPipelineJobAPI(PipelineJobIdUtils.parseJobType(parentJobId));
        result.setCheckSuccess(Boolean.valueOf(inventoryIncrementalJobAPI.aggregateDataConsistencyCheckResults(parentJobId, checkJobResult)));
        return result;
    }

    public ConsistencyCheckJobConfiguration getJobConfiguration(String jobId) {
        return this.getJobConfiguration(this.getElasticJobConfigPOJO(jobId));
    }

    protected ConsistencyCheckJobConfiguration getJobConfiguration(JobConfigurationPOJO jobConfigPOJO) {
        return new YamlConsistencyCheckJobConfigurationSwapper().swapToObject(jobConfigPOJO.getJobParameter());
    }

    @Override
    protected YamlPipelineJobConfiguration swapToYamlJobConfiguration(PipelineJobConfiguration jobConfig) {
        return new YamlConsistencyCheckJobConfigurationSwapper().swapToYamlConfiguration((ConsistencyCheckJobConfiguration)jobConfig);
    }

    @Override
    public void extendYamlJobConfiguration(YamlPipelineJobConfiguration yamlJobConfig) {
        throw new UnsupportedOperationException();
    }

    @Override
    public PipelineTaskConfiguration buildTaskConfiguration(PipelineJobConfiguration pipelineJobConfig, int jobShardingItem, PipelineProcessConfiguration pipelineProcessConfig) {
        throw new UnsupportedOperationException();
    }

    @Override
    public PipelineProcessContext buildPipelineProcessContext(PipelineJobConfiguration pipelineJobConfig) {
        throw new UnsupportedOperationException();
    }

    @Override
    protected PipelineJobInfo getJobInfo(String jobId) {
        throw new UnsupportedOperationException();
    }

    @Override
    protected String getJobClassName() {
        return ConsistencyCheckJob.class.getName();
    }

    public JobType getJobType() {
        return JobType.CONSISTENCY_CHECK;
    }
}

