/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.data.pipeline.scenario.consistencycheck;

import lombok.Generated;
import org.apache.shardingsphere.data.pipeline.api.job.JobType;
import org.apache.shardingsphere.data.pipeline.core.job.AbstractPipelineJobId;

public final class ConsistencyCheckJobId
extends AbstractPipelineJobId {
    public static final String CURRENT_VERSION = "01";
    public static final int MIN_SEQUENCE = 1;
    private static final int MAX_SEQUENCE = 3;
    private final String parentJobId;
    private final int sequence;

    public ConsistencyCheckJobId(String parentJobId, int sequence) {
        super(JobType.CONSISTENCY_CHECK, CURRENT_VERSION);
        this.parentJobId = parentJobId;
        this.sequence = sequence > 3 ? 1 : sequence;
    }

    public static int parseSequence(String checkJobId) {
        return Integer.parseInt(checkJobId.substring(checkJobId.length() - 1));
    }

    @Generated
    public String getParentJobId() {
        return this.parentJobId;
    }

    @Generated
    public int getSequence() {
        return this.sequence;
    }

    @Override
    @Generated
    public String toString() {
        return "ConsistencyCheckJobId(super=" + super.toString() + ", parentJobId=" + this.getParentJobId() + ", sequence=" + this.getSequence() + ")";
    }
}

