/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.data.pipeline.scenario.consistencycheck;

import java.util.Collection;
import java.util.concurrent.atomic.AtomicLong;
import lombok.Generated;
import org.apache.shardingsphere.data.pipeline.api.config.job.ConsistencyCheckJobConfiguration;
import org.apache.shardingsphere.data.pipeline.api.context.PipelineJobItemContext;
import org.apache.shardingsphere.data.pipeline.api.context.PipelineProcessContext;
import org.apache.shardingsphere.data.pipeline.api.job.JobStatus;
import org.apache.shardingsphere.data.pipeline.api.job.progress.listener.PipelineJobProgressListener;
import org.apache.shardingsphere.data.pipeline.api.job.progress.listener.PipelineJobProgressUpdatedParameter;
import org.apache.shardingsphere.data.pipeline.core.job.progress.persist.PipelineJobProgressPersistService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ConsistencyCheckJobItemContext
implements PipelineJobItemContext,
PipelineJobProgressListener {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ConsistencyCheckJobItemContext.class);
    private final String jobId;
    private final int shardingItem;
    private String dataSourceName;
    private volatile boolean stopping;
    private volatile JobStatus status;
    private Collection<String> tableNames;
    private volatile Long recordsCount;
    private final AtomicLong checkedRecordsCount = new AtomicLong(0L);
    private final long checkBeginTimeMillis;
    private Long checkEndTimeMillis;
    private final ConsistencyCheckJobConfiguration jobConfig;

    public ConsistencyCheckJobItemContext(ConsistencyCheckJobConfiguration jobConfig, int shardingItem, JobStatus status) {
        this.jobConfig = jobConfig;
        this.jobId = jobConfig.getJobId();
        this.shardingItem = shardingItem;
        this.status = status;
        this.checkBeginTimeMillis = System.currentTimeMillis();
    }

    public PipelineProcessContext getJobProcessContext() {
        throw new UnsupportedOperationException();
    }

    public void onProgressUpdated(PipelineJobProgressUpdatedParameter parameter) {
        this.checkedRecordsCount.addAndGet(parameter.getProcessedRecordsCount());
        PipelineJobProgressPersistService.notifyPersist(this.jobId, this.shardingItem);
    }

    @Generated
    public String getJobId() {
        return this.jobId;
    }

    @Generated
    public int getShardingItem() {
        return this.shardingItem;
    }

    @Generated
    public String getDataSourceName() {
        return this.dataSourceName;
    }

    @Generated
    public boolean isStopping() {
        return this.stopping;
    }

    @Generated
    public JobStatus getStatus() {
        return this.status;
    }

    @Generated
    public Collection<String> getTableNames() {
        return this.tableNames;
    }

    @Generated
    public Long getRecordsCount() {
        return this.recordsCount;
    }

    @Generated
    public AtomicLong getCheckedRecordsCount() {
        return this.checkedRecordsCount;
    }

    @Generated
    public long getCheckBeginTimeMillis() {
        return this.checkBeginTimeMillis;
    }

    @Generated
    public Long getCheckEndTimeMillis() {
        return this.checkEndTimeMillis;
    }

    @Generated
    public ConsistencyCheckJobConfiguration getJobConfig() {
        return this.jobConfig;
    }

    @Generated
    public void setDataSourceName(String dataSourceName) {
        this.dataSourceName = dataSourceName;
    }

    @Generated
    public void setStopping(boolean stopping) {
        this.stopping = stopping;
    }

    @Generated
    public void setStatus(JobStatus status) {
        this.status = status;
    }

    @Generated
    public void setTableNames(Collection<String> tableNames) {
        this.tableNames = tableNames;
    }

    @Generated
    public void setRecordsCount(Long recordsCount) {
        this.recordsCount = recordsCount;
    }

    @Generated
    public void setCheckEndTimeMillis(Long checkEndTimeMillis) {
        this.checkEndTimeMillis = checkEndTimeMillis;
    }
}

