/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.data.pipeline.scenario.consistencycheck;

import java.sql.SQLException;
import java.util.Map;
import lombok.Generated;
import org.apache.shardingsphere.data.pipeline.api.check.consistency.DataConsistencyCheckResult;
import org.apache.shardingsphere.data.pipeline.api.config.job.ConsistencyCheckJobConfiguration;
import org.apache.shardingsphere.data.pipeline.api.config.job.PipelineJobConfiguration;
import org.apache.shardingsphere.data.pipeline.api.executor.AbstractLifecycleExecutor;
import org.apache.shardingsphere.data.pipeline.api.executor.LifecycleExecutor;
import org.apache.shardingsphere.data.pipeline.api.job.JobStatus;
import org.apache.shardingsphere.data.pipeline.api.job.JobType;
import org.apache.shardingsphere.data.pipeline.api.task.PipelineTasksRunner;
import org.apache.shardingsphere.data.pipeline.core.api.InventoryIncrementalJobAPI;
import org.apache.shardingsphere.data.pipeline.core.api.PipelineAPIFactory;
import org.apache.shardingsphere.data.pipeline.core.execute.ExecuteCallback;
import org.apache.shardingsphere.data.pipeline.core.execute.ExecuteEngine;
import org.apache.shardingsphere.data.pipeline.core.job.PipelineJobIdUtils;
import org.apache.shardingsphere.data.pipeline.scenario.consistencycheck.ConsistencyCheckJobAPI;
import org.apache.shardingsphere.data.pipeline.scenario.consistencycheck.ConsistencyCheckJobAPIFactory;
import org.apache.shardingsphere.data.pipeline.scenario.consistencycheck.ConsistencyCheckJobItemContext;
import org.apache.shardingsphere.data.pipeline.spi.check.consistency.DataConsistencyCalculateAlgorithm;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ConsistencyCheckTasksRunner
implements PipelineTasksRunner {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ConsistencyCheckTasksRunner.class);
    private final ConsistencyCheckJobAPI checkJobAPI = ConsistencyCheckJobAPIFactory.getInstance();
    private final ConsistencyCheckJobItemContext jobItemContext;
    private final ConsistencyCheckJobConfiguration checkJobConfig;
    private final String checkJobId;
    private final String parentJobId;
    private final LifecycleExecutor checkExecutor;
    private final ExecuteCallback checkExecuteCallback;
    private volatile DataConsistencyCalculateAlgorithm calculateAlgorithm;

    public ConsistencyCheckTasksRunner(ConsistencyCheckJobItemContext jobItemContext) {
        this.jobItemContext = jobItemContext;
        this.checkJobConfig = jobItemContext.getJobConfig();
        this.checkJobId = this.checkJobConfig.getJobId();
        this.parentJobId = this.checkJobConfig.getParentJobId();
        this.checkExecutor = new CheckLifecycleExecutor();
        this.checkExecuteCallback = new CheckExecuteCallback();
    }

    public void start() {
        if (this.jobItemContext.isStopping()) {
            log.info("job stopping, ignore consistency check");
            return;
        }
        PipelineAPIFactory.getPipelineJobAPI(PipelineJobIdUtils.parseJobType(this.jobItemContext.getJobId())).persistJobItemProgress(this.jobItemContext);
        ExecuteEngine executeEngine = ExecuteEngine.newFixedThreadInstance(1, this.checkJobId + "-check");
        executeEngine.submit(this.checkExecutor, this.checkExecuteCallback);
    }

    public void stop() {
        this.jobItemContext.setStopping(true);
        log.info("stop, jobId={}, shardingItem={}", (Object)this.jobItemContext.getJobId(), (Object)this.jobItemContext.getShardingItem());
        this.checkExecutor.stop();
    }

    @Generated
    public ConsistencyCheckJobItemContext getJobItemContext() {
        return this.jobItemContext;
    }

    @Generated
    private void setCalculateAlgorithm(DataConsistencyCalculateAlgorithm calculateAlgorithm) {
        this.calculateAlgorithm = calculateAlgorithm;
    }

    private final class CheckExecuteCallback
    implements ExecuteCallback {
        private CheckExecuteCallback() {
        }

        @Override
        public void onSuccess() {
            log.info("onSuccess, check job id: {}, parent job id: {}", (Object)ConsistencyCheckTasksRunner.this.checkJobId, (Object)ConsistencyCheckTasksRunner.this.parentJobId);
            ConsistencyCheckTasksRunner.this.jobItemContext.setStatus(JobStatus.FINISHED);
            ConsistencyCheckTasksRunner.this.checkJobAPI.persistJobItemProgress(ConsistencyCheckTasksRunner.this.jobItemContext);
            ConsistencyCheckTasksRunner.this.checkJobAPI.stop(ConsistencyCheckTasksRunner.this.checkJobId);
        }

        @Override
        public void onFailure(Throwable throwable) {
            DataConsistencyCalculateAlgorithm algorithm = ConsistencyCheckTasksRunner.this.calculateAlgorithm;
            if (null != algorithm && algorithm.isCanceling()) {
                log.info("onFailure, canceling, check job id: {}, parent job id: {}", (Object)ConsistencyCheckTasksRunner.this.checkJobId, (Object)ConsistencyCheckTasksRunner.this.parentJobId);
                ConsistencyCheckTasksRunner.this.checkJobAPI.stop(ConsistencyCheckTasksRunner.this.checkJobId);
                return;
            }
            log.info("onFailure, check job id: {}, parent job id: {}", new Object[]{ConsistencyCheckTasksRunner.this.checkJobId, ConsistencyCheckTasksRunner.this.parentJobId, throwable});
            ConsistencyCheckTasksRunner.this.checkJobAPI.persistJobItemErrorMessage(ConsistencyCheckTasksRunner.this.checkJobId, 0, throwable);
            ConsistencyCheckTasksRunner.this.jobItemContext.setStatus(JobStatus.CONSISTENCY_CHECK_FAILURE);
            ConsistencyCheckTasksRunner.this.checkJobAPI.persistJobItemProgress(ConsistencyCheckTasksRunner.this.jobItemContext);
            ConsistencyCheckTasksRunner.this.checkJobAPI.stop(ConsistencyCheckTasksRunner.this.checkJobId);
        }
    }

    private final class CheckLifecycleExecutor
    extends AbstractLifecycleExecutor {
        private CheckLifecycleExecutor() {
        }

        protected void runBlocking() {
            log.info("execute consistency check, check job id: {}, parent job id: {}", (Object)ConsistencyCheckTasksRunner.this.checkJobId, (Object)ConsistencyCheckTasksRunner.this.parentJobId);
            ConsistencyCheckTasksRunner.this.checkJobAPI.persistJobItemProgress(ConsistencyCheckTasksRunner.this.jobItemContext);
            JobType jobType = PipelineJobIdUtils.parseJobType(ConsistencyCheckTasksRunner.this.parentJobId);
            InventoryIncrementalJobAPI jobAPI = (InventoryIncrementalJobAPI)PipelineAPIFactory.getPipelineJobAPI(jobType);
            PipelineJobConfiguration parentJobConfig = jobAPI.getJobConfiguration(ConsistencyCheckTasksRunner.this.parentJobId);
            DataConsistencyCalculateAlgorithm calculateAlgorithm = jobAPI.buildDataConsistencyCalculateAlgorithm(parentJobConfig, ConsistencyCheckTasksRunner.this.checkJobConfig.getAlgorithmTypeName(), ConsistencyCheckTasksRunner.this.checkJobConfig.getAlgorithmProps());
            ConsistencyCheckTasksRunner.this.setCalculateAlgorithm(calculateAlgorithm);
            Map<String, DataConsistencyCheckResult> dataConsistencyCheckResult = jobAPI.dataConsistencyCheck(parentJobConfig, calculateAlgorithm, ConsistencyCheckTasksRunner.this.jobItemContext);
            PipelineAPIFactory.getGovernanceRepositoryAPI().persistCheckJobResult(ConsistencyCheckTasksRunner.this.parentJobId, ConsistencyCheckTasksRunner.this.checkJobId, dataConsistencyCheckResult);
            ConsistencyCheckTasksRunner.this.jobItemContext.setCheckEndTimeMillis(System.currentTimeMillis());
        }

        protected void doStop() {
            DataConsistencyCalculateAlgorithm algorithm = ConsistencyCheckTasksRunner.this.calculateAlgorithm;
            log.info("doStop, algorithm={}", (Object)algorithm);
            if (null != algorithm) {
                try {
                    algorithm.cancel();
                }
                catch (SQLException ex) {
                    throw new RuntimeException(ex);
                }
            }
        }
    }
}

