/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.data.pipeline.scenario.migration;

import java.sql.SQLException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import lombok.Generated;
import org.apache.shardingsphere.data.pipeline.api.check.consistency.DataConsistencyCheckResult;
import org.apache.shardingsphere.data.pipeline.api.check.consistency.PipelineDataConsistencyChecker;
import org.apache.shardingsphere.data.pipeline.api.config.TableNameSchemaNameMapping;
import org.apache.shardingsphere.data.pipeline.api.config.job.MigrationJobConfiguration;
import org.apache.shardingsphere.data.pipeline.api.datasource.PipelineDataSourceWrapper;
import org.apache.shardingsphere.data.pipeline.api.datasource.config.PipelineDataSourceConfiguration;
import org.apache.shardingsphere.data.pipeline.api.metadata.SchemaName;
import org.apache.shardingsphere.data.pipeline.api.metadata.SchemaTableName;
import org.apache.shardingsphere.data.pipeline.api.metadata.TableName;
import org.apache.shardingsphere.data.pipeline.core.check.consistency.SingleTableInventoryDataConsistencyChecker;
import org.apache.shardingsphere.data.pipeline.core.context.InventoryIncrementalProcessContext;
import org.apache.shardingsphere.data.pipeline.core.datasource.PipelineDataSourceFactory;
import org.apache.shardingsphere.data.pipeline.core.exception.data.UnsupportedPipelineDatabaseTypeException;
import org.apache.shardingsphere.data.pipeline.core.metadata.loader.StandardPipelineTableMetaDataLoader;
import org.apache.shardingsphere.data.pipeline.scenario.consistencycheck.ConsistencyCheckJobItemContext;
import org.apache.shardingsphere.data.pipeline.spi.check.consistency.DataConsistencyCalculateAlgorithm;
import org.apache.shardingsphere.data.pipeline.spi.ratelimit.JobRateLimitAlgorithm;
import org.apache.shardingsphere.infra.util.exception.ShardingSpherePreconditions;
import org.apache.shardingsphere.infra.util.exception.external.sql.type.wrapper.SQLWrapperException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class MigrationDataConsistencyChecker
implements PipelineDataConsistencyChecker {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(MigrationDataConsistencyChecker.class);
    private final MigrationJobConfiguration jobConfig;
    private final JobRateLimitAlgorithm readRateLimitAlgorithm;
    private final TableNameSchemaNameMapping tableNameSchemaNameMapping;
    private final ConsistencyCheckJobItemContext checkJobItemContext;

    public MigrationDataConsistencyChecker(MigrationJobConfiguration jobConfig, InventoryIncrementalProcessContext processContext, ConsistencyCheckJobItemContext checkJobItemContext) {
        this.jobConfig = jobConfig;
        this.readRateLimitAlgorithm = null != processContext ? processContext.getReadRateLimitAlgorithm() : null;
        this.tableNameSchemaNameMapping = new TableNameSchemaNameMapping(TableNameSchemaNameMapping.convert((String)jobConfig.getSourceSchemaName(), new HashSet<String>(Arrays.asList(jobConfig.getSourceTableName(), jobConfig.getTargetTableName()))));
        this.checkJobItemContext = checkJobItemContext;
    }

    public Map<String, DataConsistencyCheckResult> check(DataConsistencyCalculateAlgorithm calculateAlgorithm) {
        this.verifyPipelineDatabaseType(calculateAlgorithm, this.jobConfig.getSource());
        this.verifyPipelineDatabaseType(calculateAlgorithm, this.jobConfig.getTarget());
        SchemaTableName sourceTable = new SchemaTableName(new SchemaName(this.tableNameSchemaNameMapping.getSchemaName(this.jobConfig.getSourceTableName())), new TableName(this.jobConfig.getSourceTableName()));
        SchemaTableName targetTable = new SchemaTableName(new SchemaName(this.tableNameSchemaNameMapping.getSchemaName(this.jobConfig.getTargetTableName())), new TableName(this.jobConfig.getTargetTableName()));
        LinkedHashMap<String, DataConsistencyCheckResult> result = new LinkedHashMap<String, DataConsistencyCheckResult>();
        try (PipelineDataSourceWrapper sourceDataSource = PipelineDataSourceFactory.newInstance(this.jobConfig.getSource());
             PipelineDataSourceWrapper targetDataSource = PipelineDataSourceFactory.newInstance(this.jobConfig.getTarget());){
            StandardPipelineTableMetaDataLoader metaDataLoader = new StandardPipelineTableMetaDataLoader(sourceDataSource);
            SingleTableInventoryDataConsistencyChecker singleTableInventoryChecker = new SingleTableInventoryDataConsistencyChecker(this.jobConfig.getJobId(), sourceDataSource, targetDataSource, sourceTable, targetTable, this.jobConfig.getUniqueKeyColumn(), metaDataLoader, this.readRateLimitAlgorithm, this.checkJobItemContext);
            result.put(sourceTable.getTableName().getOriginal(), singleTableInventoryChecker.check(calculateAlgorithm));
        }
        catch (SQLException ex) {
            throw new SQLWrapperException(ex);
        }
        return result;
    }

    private void verifyPipelineDatabaseType(DataConsistencyCalculateAlgorithm calculateAlgorithm, PipelineDataSourceConfiguration dataSourceConfig) {
        ShardingSpherePreconditions.checkState((boolean)calculateAlgorithm.getSupportedDatabaseTypes().contains(dataSourceConfig.getDatabaseType().getType()), () -> new UnsupportedPipelineDatabaseTypeException(dataSourceConfig.getDatabaseType()));
    }
}

